package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSamlProviderResponse(
    samlProviderArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse = {
    import UpdateSamlProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse
      .builder()
      .optionallyWith(
        samlProviderArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.samlProviderArn)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly =
    zio.aws.iam.model.UpdateSamlProviderResponse.wrap(buildAwsValue())
}
object UpdateSamlProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateSamlProviderResponse =
      zio.aws.iam.model
        .UpdateSamlProviderResponse(samlProviderArn.map(value => value))
    def samlProviderArn: Optional[ArnType]
    def getSamlProviderArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("samlProviderArn", samlProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse
  ) extends zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly {
    override val samlProviderArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.samlProviderArn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse
  ): zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly = new Wrapper(impl)
}
