package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PathType, ServerCertificateNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServerCertificateRequest(
    serverCertificateName: ServerCertificateNameType,
    newPath: Optional[PathType] = Optional.Absent,
    newServerCertificateName: Optional[ServerCertificateNameType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest = {
    import UpdateServerCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest
      .builder()
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .optionallyWith(
        newPath.map(value => PathType.unwrap(value): java.lang.String)
      )(_.newPath)
      .optionallyWith(
        newServerCertificateName.map(value =>
          ServerCertificateNameType.unwrap(value): java.lang.String
        )
      )(_.newServerCertificateName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateServerCertificateRequest.ReadOnly =
    zio.aws.iam.model.UpdateServerCertificateRequest.wrap(buildAwsValue())
}
object UpdateServerCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateServerCertificateRequest =
      zio.aws.iam.model.UpdateServerCertificateRequest(
        serverCertificateName,
        newPath.map(value => value),
        newServerCertificateName.map(value => value)
      )
    def serverCertificateName: ServerCertificateNameType
    def newPath: Optional[PathType]
    def newServerCertificateName: Optional[ServerCertificateNameType]
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
    def getNewPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("newPath", newPath)
    def getNewServerCertificateName
        : ZIO[Any, AwsError, ServerCertificateNameType] = AwsError
      .unwrapOptionField("newServerCertificateName", newServerCertificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest
  ) extends zio.aws.iam.model.UpdateServerCertificateRequest.ReadOnly {
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
    override val newPath: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.newPath())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val newServerCertificateName: Optional[ServerCertificateNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newServerCertificateName())
        .map(value =>
          zio.aws.iam.model.primitives.ServerCertificateNameType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest
  ): zio.aws.iam.model.UpdateServerCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
