package zio.aws.iam.model
import zio.aws.iam.model.primitives.{CertificateIdType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSigningCertificateRequest(
    userName: Optional[ExistingUserNameType] = Optional.Absent,
    certificateId: CertificateIdType,
    status: zio.aws.iam.model.StatusType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest = {
    import UpdateSigningCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .certificateId(CertificateIdType.unwrap(certificateId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateSigningCertificateRequest.ReadOnly =
    zio.aws.iam.model.UpdateSigningCertificateRequest.wrap(buildAwsValue())
}
object UpdateSigningCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateSigningCertificateRequest =
      zio.aws.iam.model.UpdateSigningCertificateRequest(
        userName.map(value => value),
        certificateId,
        status
      )
    def userName: Optional[ExistingUserNameType]
    def certificateId: CertificateIdType
    def status: zio.aws.iam.model.StatusType
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getCertificateId: ZIO[Any, Nothing, CertificateIdType] =
      ZIO.succeed(certificateId)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest
  ) extends zio.aws.iam.model.UpdateSigningCertificateRequest.ReadOnly {
    override val userName: Optional[ExistingUserNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userName())
        .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val certificateId: CertificateIdType =
      zio.aws.iam.model.primitives.CertificateIdType(impl.certificateId())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest
  ): zio.aws.iam.model.UpdateSigningCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
