package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PublicKeyIdType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSshPublicKeyRequest(
    userName: UserNameType,
    sshPublicKeyId: PublicKeyIdType,
    status: zio.aws.iam.model.StatusType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest = {
    import UpdateSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .sshPublicKeyId(PublicKeyIdType.unwrap(sshPublicKeyId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateSshPublicKeyRequest.ReadOnly =
    zio.aws.iam.model.UpdateSshPublicKeyRequest.wrap(buildAwsValue())
}
object UpdateSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateSshPublicKeyRequest =
      zio.aws.iam.model
        .UpdateSshPublicKeyRequest(userName, sshPublicKeyId, status)
    def userName: UserNameType
    def sshPublicKeyId: PublicKeyIdType
    def status: zio.aws.iam.model.StatusType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSshPublicKeyId: ZIO[Any, Nothing, PublicKeyIdType] =
      ZIO.succeed(sshPublicKeyId)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest
  ) extends zio.aws.iam.model.UpdateSshPublicKeyRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val sshPublicKeyId: PublicKeyIdType =
      zio.aws.iam.model.primitives.PublicKeyIdType(impl.sshPublicKeyId())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest
  ): zio.aws.iam.model.UpdateSshPublicKeyRequest.ReadOnly = new Wrapper(impl)
}
