package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UploadServerCertificateResponse(
    serverCertificateMetadata: Optional[
      zio.aws.iam.model.ServerCertificateMetadata
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse = {
    import UploadServerCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
      .builder()
      .optionallyWith(
        serverCertificateMetadata.map(value => value.buildAwsValue())
      )(_.serverCertificateMetadata)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly =
    zio.aws.iam.model.UploadServerCertificateResponse.wrap(buildAwsValue())
}
object UploadServerCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadServerCertificateResponse =
      zio.aws.iam.model.UploadServerCertificateResponse(
        serverCertificateMetadata.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverCertificateMetadata
        : Optional[zio.aws.iam.model.ServerCertificateMetadata.ReadOnly]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getServerCertificateMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverCertificateMetadata",
      serverCertificateMetadata
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
  ) extends zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly {
    override val serverCertificateMetadata
        : Optional[zio.aws.iam.model.ServerCertificateMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverCertificateMetadata())
        .map(value => zio.aws.iam.model.ServerCertificateMetadata.wrap(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse
  ): zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
