package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PublicKeyMaterialType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UploadSshPublicKeyRequest(
    userName: UserNameType,
    sshPublicKeyBody: PublicKeyMaterialType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest = {
    import UploadSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .sshPublicKeyBody(
        PublicKeyMaterialType.unwrap(sshPublicKeyBody): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UploadSshPublicKeyRequest.ReadOnly =
    zio.aws.iam.model.UploadSshPublicKeyRequest.wrap(buildAwsValue())
}
object UploadSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UploadSshPublicKeyRequest =
      zio.aws.iam.model.UploadSshPublicKeyRequest(userName, sshPublicKeyBody)
    def userName: UserNameType
    def sshPublicKeyBody: PublicKeyMaterialType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSshPublicKeyBody: ZIO[Any, Nothing, PublicKeyMaterialType] =
      ZIO.succeed(sshPublicKeyBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest
  ) extends zio.aws.iam.model.UploadSshPublicKeyRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val sshPublicKeyBody: PublicKeyMaterialType =
      zio.aws.iam.model.primitives
        .PublicKeyMaterialType(impl.sshPublicKeyBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest
  ): zio.aws.iam.model.UploadSshPublicKeyRequest.ReadOnly = new Wrapper(impl)
}
