package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  UserNameType,
  GroupNameType,
  PathType
}
import scala.jdk.CollectionConverters.*
final case class UserDetail(
    path: Optional[PathType] = Optional.Absent,
    userName: Optional[UserNameType] = Optional.Absent,
    userId: Optional[IdType] = Optional.Absent,
    arn: Optional[ArnType] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent,
    userPolicyList: Optional[Iterable[zio.aws.iam.model.PolicyDetail]] =
      Optional.Absent,
    groupList: Optional[Iterable[GroupNameType]] = Optional.Absent,
    attachedManagedPolicies: Optional[
      Iterable[zio.aws.iam.model.AttachedPolicy]
    ] = Optional.Absent,
    permissionsBoundary: Optional[
      zio.aws.iam.model.AttachedPermissionsBoundary
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.UserDetail = {
    import UserDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UserDetail
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        userPolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userPolicyList)
      .optionallyWith(
        groupList.map(value =>
          value.map { item =>
            GroupNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupList)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UserDetail.ReadOnly =
    zio.aws.iam.model.UserDetail.wrap(buildAwsValue())
}
object UserDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.UserDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UserDetail = zio.aws.iam.model.UserDetail(
      path.map(value => value),
      userName.map(value => value),
      userId.map(value => value),
      arn.map(value => value),
      createDate.map(value => value),
      userPolicyList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      groupList.map(value => value),
      attachedManagedPolicies.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      permissionsBoundary.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def path: Optional[PathType]
    def userName: Optional[UserNameType]
    def userId: Optional[IdType]
    def arn: Optional[ArnType]
    def createDate: Optional[DateType]
    def userPolicyList: Optional[List[zio.aws.iam.model.PolicyDetail.ReadOnly]]
    def groupList: Optional[List[GroupNameType]]
    def attachedManagedPolicies
        : Optional[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]]
    def permissionsBoundary
        : Optional[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getUserPolicyList
        : ZIO[Any, AwsError, List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      AwsError.unwrapOptionField("userPolicyList", userPolicyList)
    def getGroupList: ZIO[Any, AwsError, List[GroupNameType]] =
      AwsError.unwrapOptionField("groupList", groupList)
    def getAttachedManagedPolicies
        : ZIO[Any, AwsError, List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      AwsError.unwrapOptionField(
        "attachedManagedPolicies",
        attachedManagedPolicies
      )
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UserDetail
  ) extends zio.aws.iam.model.UserDetail.ReadOnly {
    override val path: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val userName: Optional[UserNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val userId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val userPolicyList
        : Optional[List[zio.aws.iam.model.PolicyDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPolicyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.PolicyDetail.wrap(item)
          }.toList
        )
    override val groupList: Optional[List[GroupNameType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.GroupNameType(item)
          }.toList
        )
    override val attachedManagedPolicies
        : Optional[List[zio.aws.iam.model.AttachedPolicy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedManagedPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.AttachedPolicy.wrap(item)
          }.toList
        )
    override val permissionsBoundary
        : Optional[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsBoundary())
        .map(value => zio.aws.iam.model.AttachedPermissionsBoundary.wrap(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UserDetail
  ): zio.aws.iam.model.UserDetail.ReadOnly = new Wrapper(impl)
}
