package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateLoginProfileResponse(
    loginProfile: zio.aws.iam.model.LoginProfile
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse = {
    import CreateLoginProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse
      .builder()
      .loginProfile(loginProfile.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly =
    zio.aws.iam.model.CreateLoginProfileResponse.wrap(buildAwsValue())
}
object CreateLoginProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateLoginProfileResponse =
      zio.aws.iam.model.CreateLoginProfileResponse(loginProfile.asEditable)
    def loginProfile: zio.aws.iam.model.LoginProfile.ReadOnly
    def getLoginProfile
        : ZIO[Any, Nothing, zio.aws.iam.model.LoginProfile.ReadOnly] =
      ZIO.succeed(loginProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse
  ) extends zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly {
    override val loginProfile: zio.aws.iam.model.LoginProfile.ReadOnly =
      zio.aws.iam.model.LoginProfile.wrap(impl.loginProfile())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse
  ): zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly = new Wrapper(impl)
}
