package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyNameType, GroupNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGroupPolicyRequest(
    groupName: GroupNameType,
    policyName: PolicyNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest = {
    import DeleteGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteGroupPolicyRequest.ReadOnly =
    zio.aws.iam.model.DeleteGroupPolicyRequest.wrap(buildAwsValue())
}
object DeleteGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteGroupPolicyRequest =
      zio.aws.iam.model.DeleteGroupPolicyRequest(groupName, policyName)
    def groupName: GroupNameType
    def policyName: PolicyNameType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest
  ) extends zio.aws.iam.model.DeleteGroupPolicyRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest
  ): zio.aws.iam.model.DeleteGroupPolicyRequest.ReadOnly = new Wrapper(impl)
}
