package zio.aws.iam.model
import zio.aws.iam.model.primitives.RoleNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteServiceLinkedRoleRequest(roleName: RoleNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest = {
    import DeleteServiceLinkedRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteServiceLinkedRoleRequest.ReadOnly =
    zio.aws.iam.model.DeleteServiceLinkedRoleRequest.wrap(buildAwsValue())
}
object DeleteServiceLinkedRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteServiceLinkedRoleRequest =
      zio.aws.iam.model.DeleteServiceLinkedRoleRequest(roleName)
    def roleName: RoleNameType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest
  ) extends zio.aws.iam.model.DeleteServiceLinkedRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest
  ): zio.aws.iam.model.DeleteServiceLinkedRoleRequest.ReadOnly = new Wrapper(
    impl
  )
}
