package zio.aws.iam.model
import zio.aws.iam.model.primitives.AccessKeyIdType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAccessKeyLastUsedRequest(accessKeyId: AccessKeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest = {
    import GetAccessKeyLastUsedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest
      .builder()
      .accessKeyId(AccessKeyIdType.unwrap(accessKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetAccessKeyLastUsedRequest.ReadOnly =
    zio.aws.iam.model.GetAccessKeyLastUsedRequest.wrap(buildAwsValue())
}
object GetAccessKeyLastUsedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccessKeyLastUsedRequest =
      zio.aws.iam.model.GetAccessKeyLastUsedRequest(accessKeyId)
    def accessKeyId: AccessKeyIdType
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyIdType] =
      ZIO.succeed(accessKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest
  ) extends zio.aws.iam.model.GetAccessKeyLastUsedRequest.ReadOnly {
    override val accessKeyId: AccessKeyIdType =
      zio.aws.iam.model.primitives.AccessKeyIdType(impl.accessKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest
  ): zio.aws.iam.model.GetAccessKeyLastUsedRequest.ReadOnly = new Wrapper(impl)
}
