package zio.aws.iam.model
import zio.aws.iam.model.primitives.ContextKeyNameType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetContextKeysForPrincipalPolicyResponse(
    contextKeyNames: Optional[Iterable[ContextKeyNameType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse = {
    import GetContextKeysForPrincipalPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse
      .builder()
      .optionallyWith(
        contextKeyNames.map(value =>
          value.map { item =>
            ContextKeyNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.contextKeyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly =
    zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse
      .wrap(buildAwsValue())
}
object GetContextKeysForPrincipalPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse =
      zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse(
        contextKeyNames.map(value => value)
      )
    def contextKeyNames: Optional[List[ContextKeyNameType]]
    def getContextKeyNames: ZIO[Any, AwsError, List[ContextKeyNameType]] =
      AwsError.unwrapOptionField("contextKeyNames", contextKeyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse
  ) extends zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly {
    override val contextKeyNames: Optional[List[ContextKeyNameType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextKeyNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.ContextKeyNameType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse
  ): zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
