package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyNameType, GroupNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetGroupPolicyRequest(
    groupName: GroupNameType,
    policyName: PolicyNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest = {
    import GetGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetGroupPolicyRequest.ReadOnly =
    zio.aws.iam.model.GetGroupPolicyRequest.wrap(buildAwsValue())
}
object GetGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetGroupPolicyRequest =
      zio.aws.iam.model.GetGroupPolicyRequest(groupName, policyName)
    def groupName: GroupNameType
    def policyName: PolicyNameType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest
  ) extends zio.aws.iam.model.GetGroupPolicyRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest
  ): zio.aws.iam.model.GetGroupPolicyRequest.ReadOnly = new Wrapper(impl)
}
