package zio.aws.iam.model
import zio.aws.iam.model.primitives.InstanceProfileNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest = {
    import GetInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.GetInstanceProfileRequest.wrap(buildAwsValue())
}
object GetInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetInstanceProfileRequest =
      zio.aws.iam.model.GetInstanceProfileRequest(instanceProfileName)
    def instanceProfileName: InstanceProfileNameType
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest
  ) extends zio.aws.iam.model.GetInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest
  ): zio.aws.iam.model.GetInstanceProfileRequest.ReadOnly = new Wrapper(impl)
}
