package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceProfileResponse(
    instanceProfile: zio.aws.iam.model.InstanceProfile
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse = {
    import GetInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse
      .builder()
      .instanceProfile(instanceProfile.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly =
    zio.aws.iam.model.GetInstanceProfileResponse.wrap(buildAwsValue())
}
object GetInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetInstanceProfileResponse =
      zio.aws.iam.model.GetInstanceProfileResponse(instanceProfile.asEditable)
    def instanceProfile: zio.aws.iam.model.InstanceProfile.ReadOnly
    def getInstanceProfile
        : ZIO[Any, Nothing, zio.aws.iam.model.InstanceProfile.ReadOnly] =
      ZIO.succeed(instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse
  ) extends zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly {
    override val instanceProfile: zio.aws.iam.model.InstanceProfile.ReadOnly =
      zio.aws.iam.model.InstanceProfile.wrap(impl.instanceProfile())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse
  ): zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly = new Wrapper(impl)
}
