package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyVersionIdType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPolicyVersionRequest(
    policyArn: ArnType,
    versionId: PolicyVersionIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest = {
    import GetPolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .versionId(PolicyVersionIdType.unwrap(versionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetPolicyVersionRequest.ReadOnly =
    zio.aws.iam.model.GetPolicyVersionRequest.wrap(buildAwsValue())
}
object GetPolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetPolicyVersionRequest =
      zio.aws.iam.model.GetPolicyVersionRequest(policyArn, versionId)
    def policyArn: ArnType
    def versionId: PolicyVersionIdType
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getVersionId: ZIO[Any, Nothing, PolicyVersionIdType] =
      ZIO.succeed(versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest
  ) extends zio.aws.iam.model.GetPolicyVersionRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val versionId: PolicyVersionIdType =
      zio.aws.iam.model.primitives.PolicyVersionIdType(impl.versionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest
  ): zio.aws.iam.model.GetPolicyVersionRequest.ReadOnly = new Wrapper(impl)
}
