package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{DateType, SAMLMetadataDocumentType}
import scala.jdk.CollectionConverters.*
final case class GetSamlProviderResponse(
    samlMetadataDocument: Optional[SAMLMetadataDocumentType] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent,
    validUntil: Optional[DateType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetSamlProviderResponse = {
    import GetSamlProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
      .builder()
      .optionallyWith(
        samlMetadataDocument.map(value =>
          SAMLMetadataDocumentType.unwrap(value): java.lang.String
        )
      )(_.samlMetadataDocument)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(validUntil.map(value => DateType.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetSamlProviderResponse.ReadOnly =
    zio.aws.iam.model.GetSamlProviderResponse.wrap(buildAwsValue())
}
object GetSamlProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetSamlProviderResponse =
      zio.aws.iam.model.GetSamlProviderResponse(
        samlMetadataDocument.map(value => value),
        createDate.map(value => value),
        validUntil.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samlMetadataDocument: Optional[SAMLMetadataDocumentType]
    def createDate: Optional[DateType]
    def validUntil: Optional[DateType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getSamlMetadataDocument: ZIO[Any, AwsError, SAMLMetadataDocumentType] =
      AwsError.unwrapOptionField("samlMetadataDocument", samlMetadataDocument)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getValidUntil: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
  ) extends zio.aws.iam.model.GetSamlProviderResponse.ReadOnly {
    override val samlMetadataDocument: Optional[SAMLMetadataDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlMetadataDocument())
        .map(value =>
          zio.aws.iam.model.primitives.SAMLMetadataDocumentType(value)
        )
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val validUntil: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetSamlProviderResponse
  ): zio.aws.iam.model.GetSamlProviderResponse.ReadOnly = new Wrapper(impl)
}
