package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PolicyDocumentType,
  PolicyNameType,
  ExistingUserNameType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetUserPolicyResponse(
    userName: ExistingUserNameType,
    policyName: PolicyNameType,
    policyDocument: PolicyDocumentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetUserPolicyResponse = {
    import GetUserPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetUserPolicyResponse
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetUserPolicyResponse.ReadOnly =
    zio.aws.iam.model.GetUserPolicyResponse.wrap(buildAwsValue())
}
object GetUserPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetUserPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetUserPolicyResponse = zio.aws.iam.model
      .GetUserPolicyResponse(userName, policyName, policyDocument)
    def userName: ExistingUserNameType
    def policyName: PolicyNameType
    def policyDocument: PolicyDocumentType
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetUserPolicyResponse
  ) extends zio.aws.iam.model.GetUserPolicyResponse.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetUserPolicyResponse
  ): zio.aws.iam.model.GetUserPolicyResponse.ReadOnly = new Wrapper(impl)
}
