package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  ExistingUserNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListGroupsForUserRequest(
    userName: ExistingUserNameType,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest = {
    import ListGroupsForUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListGroupsForUserRequest.ReadOnly =
    zio.aws.iam.model.ListGroupsForUserRequest.wrap(buildAwsValue())
}
object ListGroupsForUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListGroupsForUserRequest =
      zio.aws.iam.model.ListGroupsForUserRequest(
        userName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def userName: ExistingUserNameType
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest
  ) extends zio.aws.iam.model.ListGroupsForUserRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest
  ): zio.aws.iam.model.ListGroupsForUserRequest.ReadOnly = new Wrapper(impl)
}
