package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListInstanceProfilesResponse(
    instanceProfiles: Iterable[zio.aws.iam.model.InstanceProfile],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse = {
    import ListInstanceProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse
      .builder()
      .instanceProfiles(instanceProfiles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly =
    zio.aws.iam.model.ListInstanceProfilesResponse.wrap(buildAwsValue())
}
object ListInstanceProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListInstanceProfilesResponse =
      zio.aws.iam.model.ListInstanceProfilesResponse(
        instanceProfiles.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def instanceProfiles: List[zio.aws.iam.model.InstanceProfile.ReadOnly]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getInstanceProfiles
        : ZIO[Any, Nothing, List[zio.aws.iam.model.InstanceProfile.ReadOnly]] =
      ZIO.succeed(instanceProfiles)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse
  ) extends zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly {
    override val instanceProfiles
        : List[zio.aws.iam.model.InstanceProfile.ReadOnly] = impl
      .instanceProfiles()
      .asScala
      .map { item =>
        zio.aws.iam.model.InstanceProfile.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse
  ): zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly = new Wrapper(impl)
}
