package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  DateType,
  UserNameType,
  ServiceUserName,
  ServicePassword,
  ServiceSpecificCredentialId,
  ServiceName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ServiceSpecificCredential(
    createDate: DateType,
    serviceName: ServiceName,
    serviceUserName: ServiceUserName,
    servicePassword: ServicePassword,
    serviceSpecificCredentialId: ServiceSpecificCredentialId,
    userName: UserNameType,
    status: zio.aws.iam.model.StatusType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ServiceSpecificCredential = {
    import ServiceSpecificCredential.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ServiceSpecificCredential
      .builder()
      .createDate(DateType.unwrap(createDate): Instant)
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .serviceUserName(
        ServiceUserName.unwrap(serviceUserName): java.lang.String
      )
      .servicePassword(
        ServicePassword.unwrap(servicePassword): java.lang.String
      )
      .serviceSpecificCredentialId(
        ServiceSpecificCredentialId.unwrap(
          serviceSpecificCredentialId
        ): java.lang.String
      )
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ServiceSpecificCredential.ReadOnly =
    zio.aws.iam.model.ServiceSpecificCredential.wrap(buildAwsValue())
}
object ServiceSpecificCredential {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ServiceSpecificCredential
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ServiceSpecificCredential =
      zio.aws.iam.model.ServiceSpecificCredential(
        createDate,
        serviceName,
        serviceUserName,
        servicePassword,
        serviceSpecificCredentialId,
        userName,
        status
      )
    def createDate: DateType
    def serviceName: ServiceName
    def serviceUserName: ServiceUserName
    def servicePassword: ServicePassword
    def serviceSpecificCredentialId: ServiceSpecificCredentialId
    def userName: UserNameType
    def status: zio.aws.iam.model.StatusType
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
    def getServiceUserName: ZIO[Any, Nothing, ServiceUserName] =
      ZIO.succeed(serviceUserName)
    def getServicePassword: ZIO[Any, Nothing, ServicePassword] =
      ZIO.succeed(servicePassword)
    def getServiceSpecificCredentialId
        : ZIO[Any, Nothing, ServiceSpecificCredentialId] =
      ZIO.succeed(serviceSpecificCredentialId)
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ServiceSpecificCredential
  ) extends zio.aws.iam.model.ServiceSpecificCredential.ReadOnly {
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
    override val serviceName: ServiceName =
      zio.aws.iam.model.primitives.ServiceName(impl.serviceName())
    override val serviceUserName: ServiceUserName =
      zio.aws.iam.model.primitives.ServiceUserName(impl.serviceUserName())
    override val servicePassword: ServicePassword =
      zio.aws.iam.model.primitives.ServicePassword(impl.servicePassword())
    override val serviceSpecificCredentialId: ServiceSpecificCredentialId =
      zio.aws.iam.model.primitives
        .ServiceSpecificCredentialId(impl.serviceSpecificCredentialId())
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ServiceSpecificCredential
  ): zio.aws.iam.model.ServiceSpecificCredential.ReadOnly = new Wrapper(impl)
}
