package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  DateType,
  UserNameType,
  ServiceUserName,
  ServiceSpecificCredentialId,
  ServiceName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ServiceSpecificCredentialMetadata(
    userName: UserNameType,
    status: zio.aws.iam.model.StatusType,
    serviceUserName: ServiceUserName,
    createDate: DateType,
    serviceSpecificCredentialId: ServiceSpecificCredentialId,
    serviceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata = {
    import ServiceSpecificCredentialMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .status(status.unwrap)
      .serviceUserName(
        ServiceUserName.unwrap(serviceUserName): java.lang.String
      )
      .createDate(DateType.unwrap(createDate): Instant)
      .serviceSpecificCredentialId(
        ServiceSpecificCredentialId.unwrap(
          serviceSpecificCredentialId
        ): java.lang.String
      )
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ServiceSpecificCredentialMetadata.ReadOnly =
    zio.aws.iam.model.ServiceSpecificCredentialMetadata.wrap(buildAwsValue())
}
object ServiceSpecificCredentialMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ServiceSpecificCredentialMetadata =
      zio.aws.iam.model.ServiceSpecificCredentialMetadata(
        userName,
        status,
        serviceUserName,
        createDate,
        serviceSpecificCredentialId,
        serviceName
      )
    def userName: UserNameType
    def status: zio.aws.iam.model.StatusType
    def serviceUserName: ServiceUserName
    def createDate: DateType
    def serviceSpecificCredentialId: ServiceSpecificCredentialId
    def serviceName: ServiceName
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
    def getServiceUserName: ZIO[Any, Nothing, ServiceUserName] =
      ZIO.succeed(serviceUserName)
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
    def getServiceSpecificCredentialId
        : ZIO[Any, Nothing, ServiceSpecificCredentialId] =
      ZIO.succeed(serviceSpecificCredentialId)
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata
  ) extends zio.aws.iam.model.ServiceSpecificCredentialMetadata.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
    override val serviceUserName: ServiceUserName =
      zio.aws.iam.model.primitives.ServiceUserName(impl.serviceUserName())
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
    override val serviceSpecificCredentialId: ServiceSpecificCredentialId =
      zio.aws.iam.model.primitives
        .ServiceSpecificCredentialId(impl.serviceSpecificCredentialId())
    override val serviceName: ServiceName =
      zio.aws.iam.model.primitives.ServiceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ServiceSpecificCredentialMetadata
  ): zio.aws.iam.model.ServiceSpecificCredentialMetadata.ReadOnly = new Wrapper(
    impl
  )
}
