package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PathType, InstanceProfileNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType,
    path: Optional[PathType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest = {
    import CreateInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.CreateInstanceProfileRequest.wrap(buildAwsValue())
}
object CreateInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateInstanceProfileRequest =
      zio.aws.iam.model.CreateInstanceProfileRequest(
        instanceProfileName,
        path.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceProfileName: InstanceProfileNameType
    def path: Optional[PathType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest
  ) extends zio.aws.iam.model.CreateInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val path: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest
  ): zio.aws.iam.model.CreateInstanceProfileRequest.ReadOnly = new Wrapper(impl)
}
