package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteOpenIdConnectProviderRequest(
    openIDConnectProviderArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest = {
    import DeleteOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.DeleteOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.DeleteOpenIdConnectProviderRequest.wrap(buildAwsValue())
}
object DeleteOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteOpenIdConnectProviderRequest =
      zio.aws.iam.model
        .DeleteOpenIdConnectProviderRequest(openIDConnectProviderArn)
    def openIDConnectProviderArn: ArnType
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.DeleteOpenIdConnectProviderRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest
  ): zio.aws.iam.model.DeleteOpenIdConnectProviderRequest.ReadOnly =
    new Wrapper(impl)
}
