package zio.aws.iam.model
import zio.aws.iam.model.primitives.ExistingUserNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteUserRequest(userName: ExistingUserNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteUserRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteUserRequest.ReadOnly =
    zio.aws.iam.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteUserRequest =
      zio.aws.iam.model.DeleteUserRequest(userName)
    def userName: ExistingUserNameType
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteUserRequest
  ) extends zio.aws.iam.model.DeleteUserRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteUserRequest
  ): zio.aws.iam.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
