package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MarkerType, MaxItemsType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAccountAuthorizationDetailsRequest(
    filter: Optional[Iterable[zio.aws.iam.model.EntityType]] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest = {
    import GetAccountAuthorizationDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.filterWithStrings)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetAccountAuthorizationDetailsRequest.ReadOnly =
    zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
      .wrap(buildAwsValue())
}
object GetAccountAuthorizationDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest =
      zio.aws.iam.model.GetAccountAuthorizationDetailsRequest(
        filter.map(value => value),
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def filter: Optional[List[zio.aws.iam.model.EntityType]]
    def maxItems: Optional[MaxItemsType]
    def marker: Optional[MarkerType]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.iam.model.EntityType]] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
  ) extends zio.aws.iam.model.GetAccountAuthorizationDetailsRequest.ReadOnly {
    override val filter: Optional[List[zio.aws.iam.model.EntityType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.EntityType.wrap(item)
          }.toList
        )
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest
  ): zio.aws.iam.model.GetAccountAuthorizationDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
