package zio.aws.iam.model
import zio.aws.iam.model.primitives.{UserNameType, SerialNumberType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMfaDeviceRequest(
    serialNumber: SerialNumberType,
    userName: Optional[UserNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest = {
    import GetMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest
      .builder()
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.GetMfaDeviceRequest.wrap(buildAwsValue())
}
object GetMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetMfaDeviceRequest = zio.aws.iam.model
      .GetMfaDeviceRequest(serialNumber, userName.map(value => value))
    def serialNumber: SerialNumberType
    def userName: Optional[UserNameType]
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest
  ) extends zio.aws.iam.model.GetMfaDeviceRequest.ReadOnly {
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val userName: Optional[UserNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetMfaDeviceRequest
  ): zio.aws.iam.model.GetMfaDeviceRequest.ReadOnly = new Wrapper(impl)
}
