package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSshPublicKeyResponse(
    sshPublicKey: Optional[zio.aws.iam.model.SSHPublicKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse = {
    import GetSshPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse
      .builder()
      .optionallyWith(sshPublicKey.map(value => value.buildAwsValue()))(
        _.sshPublicKey
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly =
    zio.aws.iam.model.GetSshPublicKeyResponse.wrap(buildAwsValue())
}
object GetSshPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetSshPublicKeyResponse =
      zio.aws.iam.model
        .GetSshPublicKeyResponse(sshPublicKey.map(value => value.asEditable))
    def sshPublicKey: Optional[zio.aws.iam.model.SSHPublicKey.ReadOnly]
    def getSshPublicKey
        : ZIO[Any, AwsError, zio.aws.iam.model.SSHPublicKey.ReadOnly] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse
  ) extends zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly {
    override val sshPublicKey
        : Optional[zio.aws.iam.model.SSHPublicKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sshPublicKey())
        .map(value => zio.aws.iam.model.SSHPublicKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse
  ): zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly = new Wrapper(impl)
}
