package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVirtualMfaDevicesResponse(
    virtualMFADevices: Iterable[zio.aws.iam.model.VirtualMFADevice],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse = {
    import ListVirtualMfaDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse
      .builder()
      .virtualMFADevices(virtualMFADevices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly =
    zio.aws.iam.model.ListVirtualMfaDevicesResponse.wrap(buildAwsValue())
}
object ListVirtualMfaDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListVirtualMfaDevicesResponse =
      zio.aws.iam.model.ListVirtualMfaDevicesResponse(
        virtualMFADevices.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def virtualMFADevices: List[zio.aws.iam.model.VirtualMFADevice.ReadOnly]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getVirtualMFADevices
        : ZIO[Any, Nothing, List[zio.aws.iam.model.VirtualMFADevice.ReadOnly]] =
      ZIO.succeed(virtualMFADevices)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse
  ) extends zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly {
    override val virtualMFADevices
        : List[zio.aws.iam.model.VirtualMFADevice.ReadOnly] = impl
      .virtualMFADevices()
      .asScala
      .map { item =>
        zio.aws.iam.model.VirtualMFADevice.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse
  ): zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
