package zio.aws.iam
import zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.iam.model.{
  DeleteAccountPasswordPolicyResponse,
  DeleteUserRequest,
  DeleteGroupResponse,
  CreateSamlProviderResponse,
  GetPolicyVersionRequest,
  DeleteRolePermissionsBoundaryResponse,
  GenerateServiceLastAccessedDetailsRequest,
  TagSamlProviderRequest,
  ListAttachedUserPoliciesRequest,
  UpdateOpenIdConnectProviderThumbprintResponse,
  ListServerCertificatesResponse,
  ListMfaDevicesResponse,
  PolicyVersion,
  UpdateAccessKeyRequest,
  ListInstanceProfilesForRoleResponse,
  GetContextKeysForCustomPolicyRequest,
  AttachUserPolicyResponse,
  GenerateServiceLastAccessedDetailsResponse,
  DeleteVirtualMfaDeviceRequest,
  DeleteVirtualMfaDeviceResponse,
  GetAccountPasswordPolicyResponse,
  GetContextKeysForPrincipalPolicyResponse,
  SetSecurityTokenServicePreferencesRequest,
  ListVirtualMfaDevicesRequest,
  GetAccountSummaryRequest,
  DeletePolicyVersionResponse,
  GetGroupPolicyResponse,
  ChangePasswordRequest,
  CreateVirtualMfaDeviceResponse,
  GetServerCertificateRequest,
  ListInstanceProfilesForRoleRequest,
  ListMfaDevicesRequest,
  DeleteServiceLinkedRoleRequest,
  GetAccessKeyLastUsedRequest,
  ListVirtualMfaDevicesResponse,
  ListInstanceProfilesRequest,
  GetLoginProfileResponse,
  EvaluationResult,
  ListPoliciesGrantingServiceAccessRequest,
  ListMfaDeviceTagsRequest,
  GetServiceLastAccessedDetailsRequest,
  DeleteServerCertificateResponse,
  ListSigningCertificatesRequest,
  ResetServiceSpecificCredentialResponse,
  ListSamlProvidersRequest,
  ServerCertificateMetadata,
  PutGroupPolicyResponse,
  TagInstanceProfileRequest,
  SetDefaultPolicyVersionResponse,
  UntagRoleRequest,
  PutRolePermissionsBoundaryRequest,
  CreatePolicyResponse,
  UntagPolicyResponse,
  GetRolePolicyRequest,
  ListServerCertificatesRequest,
  UntagInstanceProfileResponse,
  ListUserTagsRequest,
  MFADevice,
  DeleteRolePermissionsBoundaryRequest,
  CreateRoleRequest,
  DeleteSshPublicKeyRequest,
  UpdateServerCertificateRequest,
  GetInstanceProfileRequest,
  ListEntitiesForPolicyResponse,
  CreateInstanceProfileRequest,
  ListRoleTagsRequest,
  ListPoliciesRequest,
  ListOpenIdConnectProviderTagsResponse,
  ListGroupPoliciesRequest,
  ListSigningCertificatesResponse,
  DeleteServerCertificateRequest,
  GetServiceLastAccessedDetailsWithEntitiesRequest,
  ListSamlProviderTagsRequest,
  DeleteAccessKeyRequest,
  GetContextKeysForPrincipalPolicyRequest,
  GetSshPublicKeyResponse,
  DetachRolePolicyResponse,
  GetGroupRequest,
  DeleteGroupPolicyRequest,
  GetAccountPasswordPolicyRequest,
  DeleteSigningCertificateResponse,
  DeleteServiceLinkedRoleResponse,
  CreateAccessKeyResponse,
  GetPolicyVersionResponse,
  GetRoleResponse,
  ListPolicyTagsResponse,
  DetachRolePolicyRequest,
  UpdateRoleDescriptionRequest,
  ListUsersRequest,
  SetSecurityTokenServicePreferencesResponse,
  CreateAccountAliasRequest,
  GetUserPolicyResponse,
  PutRolePermissionsBoundaryResponse,
  ListUsersResponse,
  ListServerCertificateTagsRequest,
  CreateServiceSpecificCredentialResponse,
  UpdateGroupRequest,
  AddClientIdToOpenIdConnectProviderRequest,
  ListPoliciesResponse,
  CreateVirtualMfaDeviceRequest,
  PutGroupPolicyRequest,
  DetachGroupPolicyRequest,
  UpdateSigningCertificateRequest,
  ListOpenIdConnectProvidersRequest,
  CreateLoginProfileResponse,
  ListRolesResponse,
  ListUserPoliciesRequest,
  CreateInstanceProfileResponse,
  DeleteOpenIdConnectProviderResponse,
  ListMfaDeviceTagsResponse,
  User,
  PutUserPermissionsBoundaryResponse,
  GetServiceLinkedRoleDeletionStatusResponse,
  UpdateAccountPasswordPolicyRequest,
  UpdateServiceSpecificCredentialRequest,
  UploadSshPublicKeyResponse,
  DeleteUserPermissionsBoundaryRequest,
  CreateServiceLinkedRoleRequest,
  ListAttachedRolePoliciesRequest,
  GetAccountSummaryResponse,
  AccessKeyMetadata,
  ListAccessKeysRequest,
  GetLoginProfileRequest,
  ListAttachedRolePoliciesResponse,
  RemoveClientIdFromOpenIdConnectProviderRequest,
  UpdateSamlProviderRequest,
  UpdateLoginProfileResponse,
  GetUserPolicyRequest,
  GetContextKeysForCustomPolicyResponse,
  DeactivateMfaDeviceRequest,
  PutUserPermissionsBoundaryRequest,
  CreateAccountAliasResponse,
  RemoveRoleFromInstanceProfileRequest,
  CreateOpenIdConnectProviderResponse,
  ListPolicyVersionsResponse,
  GetSamlProviderRequest,
  UpdateSshPublicKeyResponse,
  Tag,
  UpdateLoginProfileRequest,
  ListSshPublicKeysRequest,
  UntagInstanceProfileRequest,
  DeleteGroupPolicyResponse,
  SimulateCustomPolicyRequest,
  TagRoleResponse,
  ListGroupsForUserRequest,
  SimulateCustomPolicyResponse,
  GetOpenIdConnectProviderResponse,
  DeleteGroupRequest,
  AttachGroupPolicyRequest,
  TagUserRequest,
  GetUserResponse,
  CreateOpenIdConnectProviderRequest,
  GetMfaDeviceResponse,
  UpdateAccessKeyResponse,
  DeleteInstanceProfileRequest,
  CreateServiceLinkedRoleResponse,
  UserDetail,
  GetOrganizationsAccessReportRequest,
  CreateSamlProviderRequest,
  ListGroupsForUserResponse,
  GenerateCredentialReportResponse,
  GetSshPublicKeyRequest,
  SimulatePrincipalPolicyResponse,
  UntagPolicyRequest,
  ListInstanceProfilesResponse,
  ListGroupsRequest,
  DeactivateMfaDeviceResponse,
  AttachRolePolicyResponse,
  DeleteAccountPasswordPolicyRequest,
  Group,
  ListPolicyTagsRequest,
  DeleteServiceSpecificCredentialResponse,
  DeleteSamlProviderResponse,
  AttachUserPolicyRequest,
  GetServiceLastAccessedDetailsWithEntitiesResponse,
  DeleteServiceSpecificCredentialRequest,
  DetachUserPolicyResponse,
  RemoveUserFromGroupResponse,
  AddRoleToInstanceProfileRequest,
  PutUserPolicyResponse,
  TagOpenIdConnectProviderRequest,
  DeleteSigningCertificateRequest,
  GetServiceLinkedRoleDeletionStatusRequest,
  DeletePolicyVersionRequest,
  GetMfaDeviceRequest,
  UntagMfaDeviceResponse,
  RemoveClientIdFromOpenIdConnectProviderResponse,
  ListAttachedGroupPoliciesResponse,
  UpdateAssumeRolePolicyResponse,
  ListUserTagsResponse,
  TagMfaDeviceRequest,
  UpdateServerCertificateResponse,
  DetachGroupPolicyResponse,
  GenerateOrganizationsAccessReportRequest,
  GetAccessKeyLastUsedResponse,
  TagServerCertificateResponse,
  ListEntitiesForPolicyRequest,
  EnableMfaDeviceRequest,
  GetPolicyResponse,
  CreateUserRequest,
  ListRolesRequest,
  UpdateRoleDescriptionResponse,
  TagServerCertificateRequest,
  UntagUserRequest,
  UntagServerCertificateRequest,
  SetDefaultPolicyVersionRequest,
  GetSamlProviderResponse,
  AttachGroupPolicyResponse,
  DeleteRolePolicyResponse,
  DeleteSshPublicKeyResponse,
  ListSshPublicKeysResponse,
  CreateUserResponse,
  ListUserPoliciesResponse,
  DeletePolicyResponse,
  TagSamlProviderResponse,
  ListGroupsResponse,
  DetachUserPolicyRequest,
  TagMfaDeviceResponse,
  RemoveRoleFromInstanceProfileResponse,
  UpdateRoleRequest,
  Policy,
  UntagSamlProviderRequest,
  PutUserPolicyRequest,
  DeleteRolePolicyRequest,
  GetGroupPolicyRequest,
  ListSamlProvidersResponse,
  GetInstanceProfileResponse,
  UpdateServiceSpecificCredentialResponse,
  UntagRoleResponse,
  ListInstanceProfileTagsRequest,
  SSHPublicKeyMetadata,
  AttachedPolicy,
  UploadSigningCertificateResponse,
  ListServerCertificateTagsResponse,
  GetUserRequest,
  CreateServiceSpecificCredentialRequest,
  UpdateOpenIdConnectProviderThumbprintRequest,
  UntagSamlProviderResponse,
  AddUserToGroupRequest,
  GetOrganizationsAccessReportResponse,
  ListAttachedUserPoliciesResponse,
  ResetServiceSpecificCredentialRequest,
  ListPolicyVersionsRequest,
  InstanceProfile,
  GetAccountAuthorizationDetailsResponse,
  CreateRoleResponse,
  ListServiceSpecificCredentialsResponse,
  GetServerCertificateResponse,
  GetPolicyRequest,
  UpdateRoleResponse,
  UploadSigningCertificateRequest,
  DeleteRoleResponse,
  CreateGroupResponse,
  CreatePolicyVersionRequest,
  ChangePasswordResponse,
  GetCredentialReportResponse,
  UntagUserResponse,
  DeleteSamlProviderRequest,
  UploadSshPublicKeyRequest,
  DeleteInstanceProfileResponse,
  DeleteLoginProfileRequest,
  DeleteUserResponse,
  DeleteUserPermissionsBoundaryResponse,
  CreateLoginProfileRequest,
  ListAttachedGroupPoliciesRequest,
  TagOpenIdConnectProviderResponse,
  GetServiceLastAccessedDetailsResponse,
  GetRolePolicyResponse,
  GenerateOrganizationsAccessReportResponse,
  TagRoleRequest,
  CreateGroupRequest,
  AddRoleToInstanceProfileResponse,
  PutRolePolicyRequest,
  ListOpenIdConnectProviderTagsRequest,
  ListInstanceProfileTagsResponse,
  UpdateUserRequest,
  DeleteAccountAliasResponse,
  ListServiceSpecificCredentialsRequest,
  ListOpenIdConnectProvidersResponse,
  ListAccountAliasesRequest,
  UpdateSshPublicKeyRequest,
  DeleteRoleRequest,
  RemoveUserFromGroupRequest,
  CreateAccessKeyRequest,
  ListAccessKeysResponse,
  GetCredentialReportRequest,
  VirtualMFADevice,
  GenerateCredentialReportRequest,
  GetRoleRequest,
  ListAccountAliasesResponse,
  AddUserToGroupResponse,
  GetAccountAuthorizationDetailsRequest,
  UpdateSamlProviderResponse,
  UpdateAccountPasswordPolicyResponse,
  PutRolePolicyResponse,
  TagUserResponse,
  UploadServerCertificateRequest,
  UpdateSigningCertificateResponse,
  ListRolePoliciesRequest,
  UpdateUserResponse,
  UntagMfaDeviceRequest,
  TagPolicyResponse,
  GetOpenIdConnectProviderRequest,
  SimulatePrincipalPolicyRequest,
  Role,
  AddClientIdToOpenIdConnectProviderResponse,
  DeletePolicyRequest,
  ListGroupPoliciesResponse,
  TagPolicyRequest,
  UpdateAssumeRolePolicyRequest,
  SigningCertificate,
  UntagServerCertificateResponse,
  DeleteOpenIdConnectProviderRequest,
  ResyncMfaDeviceRequest,
  GetGroupResponse,
  CreatePolicyVersionResponse,
  TagInstanceProfileResponse,
  EnableMfaDeviceResponse,
  ListPoliciesGrantingServiceAccessResponse,
  PolicyGroup,
  ListSamlProviderTagsResponse,
  CreatePolicyRequest,
  UploadServerCertificateResponse,
  ListRolePoliciesResponse,
  DeleteLoginProfileResponse,
  DeleteAccountAliasRequest,
  UntagOpenIdConnectProviderRequest,
  UpdateGroupResponse,
  DeleteAccessKeyResponse,
  AttachRolePolicyRequest,
  DeleteUserPolicyResponse,
  DeleteUserPolicyRequest,
  UntagOpenIdConnectProviderResponse,
  ResyncMfaDeviceResponse,
  ListRoleTagsResponse
}
import zio.aws.iam.model.primitives.{AccountAliasType, PolicyNameType}
import zio.stream.ZStream
import software.amazon.awssdk.services.iam.{
  IamAsyncClientBuilder,
  IamAsyncClient
}
import software.amazon.awssdk.services.iam.paginators.{
  SimulatePrincipalPolicyPublisher,
  ListGroupPoliciesPublisher,
  ListAccountAliasesPublisher,
  ListRolePoliciesPublisher,
  ListGroupsPublisher,
  ListSSHPublicKeysPublisher,
  ListAttachedUserPoliciesPublisher,
  ListAccessKeysPublisher,
  ListMFADeviceTagsPublisher,
  ListInstanceProfileTagsPublisher,
  ListUserPoliciesPublisher,
  ListAttachedRolePoliciesPublisher,
  ListGroupsForUserPublisher,
  ListEntitiesForPolicyPublisher,
  ListRolesPublisher,
  ListSigningCertificatesPublisher,
  GetAccountAuthorizationDetailsPublisher,
  SimulateCustomPolicyPublisher,
  GetGroupPublisher,
  ListUserTagsPublisher,
  ListAttachedGroupPoliciesPublisher,
  ListInstanceProfilesPublisher,
  ListPolicyVersionsPublisher,
  ListSAMLProviderTagsPublisher,
  ListOpenIDConnectProviderTagsPublisher,
  ListMFADevicesPublisher,
  ListRoleTagsPublisher,
  ListVirtualMFADevicesPublisher,
  ListUsersPublisher,
  ListPoliciesPublisher,
  ListPolicyTagsPublisher,
  ListServerCertificateTagsPublisher,
  ListInstanceProfilesForRolePublisher,
  ListServerCertificatesPublisher
}
import scala.jdk.CollectionConverters.*
trait Iam extends AspectSupport[Iam] {
  val api: IamAsyncClient
  def getOpenIDConnectProvider(
      request: zio.aws.iam.model.GetOpenIdConnectProviderRequest
  ): IO[AwsError, zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly]
  def listUserPolicies(
      request: zio.aws.iam.model.ListUserPoliciesRequest
  ): ZStream[Any, AwsError, PolicyNameType]
  def listUserPoliciesPaginated(
      request: zio.aws.iam.model.ListUserPoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListUserPoliciesResponse.ReadOnly]
  def deleteAccountAlias(
      request: zio.aws.iam.model.DeleteAccountAliasRequest
  ): IO[AwsError, Unit]
  def deleteRolePolicy(
      request: zio.aws.iam.model.DeleteRolePolicyRequest
  ): IO[AwsError, Unit]
  def uploadSSHPublicKey(
      request: zio.aws.iam.model.UploadSshPublicKeyRequest
  ): IO[AwsError, zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly]
  def deleteOpenIDConnectProvider(
      request: zio.aws.iam.model.DeleteOpenIdConnectProviderRequest
  ): IO[AwsError, Unit]
  def listUsers(
      request: zio.aws.iam.model.ListUsersRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.User.ReadOnly]
  def listUsersPaginated(
      request: zio.aws.iam.model.ListUsersRequest
  ): IO[AwsError, zio.aws.iam.model.ListUsersResponse.ReadOnly]
  def tagServerCertificate(
      request: zio.aws.iam.model.TagServerCertificateRequest
  ): IO[AwsError, Unit]
  def tagRole(request: zio.aws.iam.model.TagRoleRequest): IO[AwsError, Unit]
  def updateUser(
      request: zio.aws.iam.model.UpdateUserRequest
  ): IO[AwsError, Unit]
  def updateSAMLProvider(
      request: zio.aws.iam.model.UpdateSamlProviderRequest
  ): IO[AwsError, zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly]
  def untagInstanceProfile(
      request: zio.aws.iam.model.UntagInstanceProfileRequest
  ): IO[AwsError, Unit]
  def createSAMLProvider(
      request: zio.aws.iam.model.CreateSamlProviderRequest
  ): IO[AwsError, zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly]
  def enableMFADevice(
      request: zio.aws.iam.model.EnableMfaDeviceRequest
  ): IO[AwsError, Unit]
  def removeClientIDFromOpenIDConnectProvider(
      request: zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
  ): IO[AwsError, Unit]
  def addClientIDToOpenIDConnectProvider(
      request: zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest
  ): IO[AwsError, Unit]
  def listSSHPublicKeys(
      request: zio.aws.iam.model.ListSshPublicKeysRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly]
  def listSSHPublicKeysPaginated(
      request: zio.aws.iam.model.ListSshPublicKeysRequest
  ): IO[AwsError, zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly]
  def getLoginProfile(
      request: zio.aws.iam.model.GetLoginProfileRequest
  ): IO[AwsError, zio.aws.iam.model.GetLoginProfileResponse.ReadOnly]
  def uploadSigningCertificate(
      request: zio.aws.iam.model.UploadSigningCertificateRequest
  ): IO[AwsError, zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly]
  def detachRolePolicy(
      request: zio.aws.iam.model.DetachRolePolicyRequest
  ): IO[AwsError, Unit]
  def resyncMFADevice(
      request: zio.aws.iam.model.ResyncMfaDeviceRequest
  ): IO[AwsError, Unit]
  def listServiceSpecificCredentials(
      request: zio.aws.iam.model.ListServiceSpecificCredentialsRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly
  ]
  def listAttachedRolePolicies(
      request: zio.aws.iam.model.ListAttachedRolePoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.AttachedPolicy.ReadOnly]
  def listAttachedRolePoliciesPaginated(
      request: zio.aws.iam.model.ListAttachedRolePoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly]
  def getSSHPublicKey(
      request: zio.aws.iam.model.GetSshPublicKeyRequest
  ): IO[AwsError, zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly]
  def untagSAMLProvider(
      request: zio.aws.iam.model.UntagSamlProviderRequest
  ): IO[AwsError, Unit]
  def simulateCustomPolicy(
      request: zio.aws.iam.model.SimulateCustomPolicyRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.EvaluationResult.ReadOnly]
  def simulateCustomPolicyPaginated(
      request: zio.aws.iam.model.SimulateCustomPolicyRequest
  ): IO[AwsError, zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly]
  def deleteAccessKey(
      request: zio.aws.iam.model.DeleteAccessKeyRequest
  ): IO[AwsError, Unit]
  def getServiceLastAccessedDetails(
      request: zio.aws.iam.model.GetServiceLastAccessedDetailsRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly
  ]
  def deleteUserPolicy(
      request: zio.aws.iam.model.DeleteUserPolicyRequest
  ): IO[AwsError, Unit]
  def untagUser(request: zio.aws.iam.model.UntagUserRequest): IO[AwsError, Unit]
  def createServiceSpecificCredential(
      request: zio.aws.iam.model.CreateServiceSpecificCredentialRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly
  ]
  def listSAMLProviders(
      request: zio.aws.iam.model.ListSamlProvidersRequest
  ): IO[AwsError, zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly]
  def listPoliciesGrantingServiceAccess(
      request: zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly
  ]
  def getGroupPolicy(
      request: zio.aws.iam.model.GetGroupPolicyRequest
  ): IO[AwsError, zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly]
  def uploadServerCertificate(
      request: zio.aws.iam.model.UploadServerCertificateRequest
  ): IO[AwsError, zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly]
  def updateServerCertificate(
      request: zio.aws.iam.model.UpdateServerCertificateRequest
  ): IO[AwsError, Unit]
  def deleteGroup(
      request: zio.aws.iam.model.DeleteGroupRequest
  ): IO[AwsError, Unit]
  def removeRoleFromInstanceProfile(
      request: zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest
  ): IO[AwsError, Unit]
  def createRole(
      request: zio.aws.iam.model.CreateRoleRequest
  ): IO[AwsError, zio.aws.iam.model.CreateRoleResponse.ReadOnly]
  def getAccountSummary()
      : IO[AwsError, zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly]
  def getMFADevice(
      request: zio.aws.iam.model.GetMfaDeviceRequest
  ): IO[AwsError, zio.aws.iam.model.GetMfaDeviceResponse.ReadOnly]
  def changePassword(
      request: zio.aws.iam.model.ChangePasswordRequest
  ): IO[AwsError, Unit]
  def listRolePolicies(
      request: zio.aws.iam.model.ListRolePoliciesRequest
  ): ZStream[Any, AwsError, PolicyNameType]
  def listRolePoliciesPaginated(
      request: zio.aws.iam.model.ListRolePoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly]
  def detachGroupPolicy(
      request: zio.aws.iam.model.DetachGroupPolicyRequest
  ): IO[AwsError, Unit]
  def listGroupsForUser(
      request: zio.aws.iam.model.ListGroupsForUserRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Group.ReadOnly]
  def listGroupsForUserPaginated(
      request: zio.aws.iam.model.ListGroupsForUserRequest
  ): IO[AwsError, zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly]
  def deleteVirtualMFADevice(
      request: zio.aws.iam.model.DeleteVirtualMfaDeviceRequest
  ): IO[AwsError, Unit]
  def listAttachedGroupPolicies(
      request: zio.aws.iam.model.ListAttachedGroupPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.AttachedPolicy.ReadOnly]
  def listAttachedGroupPoliciesPaginated(
      request: zio.aws.iam.model.ListAttachedGroupPoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListAttachedGroupPoliciesResponse.ReadOnly]
  def getUser(
      request: zio.aws.iam.model.GetUserRequest
  ): IO[AwsError, zio.aws.iam.model.GetUserResponse.ReadOnly]
  def deleteAccountPasswordPolicy(): IO[AwsError, Unit]
  def getContextKeysForPrincipalPolicy(
      request: zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly
  ]
  def listGroups(
      request: zio.aws.iam.model.ListGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Group.ReadOnly]
  def listGroupsPaginated(
      request: zio.aws.iam.model.ListGroupsRequest
  ): IO[AwsError, zio.aws.iam.model.ListGroupsResponse.ReadOnly]
  def listPolicyVersions(
      request: zio.aws.iam.model.ListPolicyVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.PolicyVersion.ReadOnly]
  def listPolicyVersionsPaginated(
      request: zio.aws.iam.model.ListPolicyVersionsRequest
  ): IO[AwsError, zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly]
  def getRolePolicy(
      request: zio.aws.iam.model.GetRolePolicyRequest
  ): IO[AwsError, zio.aws.iam.model.GetRolePolicyResponse.ReadOnly]
  def tagOpenIDConnectProvider(
      request: zio.aws.iam.model.TagOpenIdConnectProviderRequest
  ): IO[AwsError, Unit]
  def deleteRole(
      request: zio.aws.iam.model.DeleteRoleRequest
  ): IO[AwsError, Unit]
  def updateOpenIDConnectProviderThumbprint(
      request: zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
  ): IO[AwsError, Unit]
  def untagPolicy(
      request: zio.aws.iam.model.UntagPolicyRequest
  ): IO[AwsError, Unit]
  def detachUserPolicy(
      request: zio.aws.iam.model.DetachUserPolicyRequest
  ): IO[AwsError, Unit]
  def listEntitiesForPolicy(
      request: zio.aws.iam.model.ListEntitiesForPolicyRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.PolicyGroup.ReadOnly]
  def listEntitiesForPolicyPaginated(
      request: zio.aws.iam.model.ListEntitiesForPolicyRequest
  ): IO[AwsError, zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly]
  def listMFADeviceTags(
      request: zio.aws.iam.model.ListMfaDeviceTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listMFADeviceTagsPaginated(
      request: zio.aws.iam.model.ListMfaDeviceTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListMfaDeviceTagsResponse.ReadOnly]
  def deleteSSHPublicKey(
      request: zio.aws.iam.model.DeleteSshPublicKeyRequest
  ): IO[AwsError, Unit]
  def createUser(
      request: zio.aws.iam.model.CreateUserRequest
  ): IO[AwsError, zio.aws.iam.model.CreateUserResponse.ReadOnly]
  def deleteSigningCertificate(
      request: zio.aws.iam.model.DeleteSigningCertificateRequest
  ): IO[AwsError, Unit]
  def setDefaultPolicyVersion(
      request: zio.aws.iam.model.SetDefaultPolicyVersionRequest
  ): IO[AwsError, Unit]
  def updateRole(
      request: zio.aws.iam.model.UpdateRoleRequest
  ): IO[AwsError, zio.aws.iam.model.UpdateRoleResponse.ReadOnly]
  def listSAMLProviderTags(
      request: zio.aws.iam.model.ListSamlProviderTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listSAMLProviderTagsPaginated(
      request: zio.aws.iam.model.ListSamlProviderTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListSamlProviderTagsResponse.ReadOnly]
  def createServiceLinkedRole(
      request: zio.aws.iam.model.CreateServiceLinkedRoleRequest
  ): IO[AwsError, zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly]
  def addUserToGroup(
      request: zio.aws.iam.model.AddUserToGroupRequest
  ): IO[AwsError, Unit]
  def deleteServiceSpecificCredential(
      request: zio.aws.iam.model.DeleteServiceSpecificCredentialRequest
  ): IO[AwsError, Unit]
  def putRolePermissionsBoundary(
      request: zio.aws.iam.model.PutRolePermissionsBoundaryRequest
  ): IO[AwsError, Unit]
  def deleteUserPermissionsBoundary(
      request: zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest
  ): IO[AwsError, Unit]
  def putRolePolicy(
      request: zio.aws.iam.model.PutRolePolicyRequest
  ): IO[AwsError, Unit]
  def listSigningCertificates(
      request: zio.aws.iam.model.ListSigningCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.SigningCertificate.ReadOnly]
  def listSigningCertificatesPaginated(
      request: zio.aws.iam.model.ListSigningCertificatesRequest
  ): IO[AwsError, zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly]
  def createAccessKey(
      request: zio.aws.iam.model.CreateAccessKeyRequest
  ): IO[AwsError, zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly]
  def untagOpenIDConnectProvider(
      request: zio.aws.iam.model.UntagOpenIdConnectProviderRequest
  ): IO[AwsError, Unit]
  def tagInstanceProfile(
      request: zio.aws.iam.model.TagInstanceProfileRequest
  ): IO[AwsError, Unit]
  def listRoles(
      request: zio.aws.iam.model.ListRolesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Role.ReadOnly]
  def listRolesPaginated(
      request: zio.aws.iam.model.ListRolesRequest
  ): IO[AwsError, zio.aws.iam.model.ListRolesResponse.ReadOnly]
  def listPolicies(
      request: zio.aws.iam.model.ListPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Policy.ReadOnly]
  def listPoliciesPaginated(
      request: zio.aws.iam.model.ListPoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListPoliciesResponse.ReadOnly]
  def putGroupPolicy(
      request: zio.aws.iam.model.PutGroupPolicyRequest
  ): IO[AwsError, Unit]
  def createLoginProfile(
      request: zio.aws.iam.model.CreateLoginProfileRequest
  ): IO[AwsError, zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly]
  def deleteGroupPolicy(
      request: zio.aws.iam.model.DeleteGroupPolicyRequest
  ): IO[AwsError, Unit]
  def createOpenIDConnectProvider(
      request: zio.aws.iam.model.CreateOpenIdConnectProviderRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly
  ]
  def generateOrganizationsAccessReport(
      request: zio.aws.iam.model.GenerateOrganizationsAccessReportRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly
  ]
  def generateServiceLastAccessedDetails(
      request: zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly
  ]
  def getUserPolicy(
      request: zio.aws.iam.model.GetUserPolicyRequest
  ): IO[AwsError, zio.aws.iam.model.GetUserPolicyResponse.ReadOnly]
  def getAccountPasswordPolicy(): IO[
    AwsError,
    zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly
  ]
  def updateAccessKey(
      request: zio.aws.iam.model.UpdateAccessKeyRequest
  ): IO[AwsError, Unit]
  def deletePolicyVersion(
      request: zio.aws.iam.model.DeletePolicyVersionRequest
  ): IO[AwsError, Unit]
  def createVirtualMFADevice(
      request: zio.aws.iam.model.CreateVirtualMfaDeviceRequest
  ): IO[AwsError, zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly]
  def removeUserFromGroup(
      request: zio.aws.iam.model.RemoveUserFromGroupRequest
  ): IO[AwsError, Unit]
  def deleteServerCertificate(
      request: zio.aws.iam.model.DeleteServerCertificateRequest
  ): IO[AwsError, Unit]
  def untagRole(request: zio.aws.iam.model.UntagRoleRequest): IO[AwsError, Unit]
  def addRoleToInstanceProfile(
      request: zio.aws.iam.model.AddRoleToInstanceProfileRequest
  ): IO[AwsError, Unit]
  def putUserPermissionsBoundary(
      request: zio.aws.iam.model.PutUserPermissionsBoundaryRequest
  ): IO[AwsError, Unit]
  def resetServiceSpecificCredential(
      request: zio.aws.iam.model.ResetServiceSpecificCredentialRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly
  ]
  def listVirtualMFADevices(
      request: zio.aws.iam.model.ListVirtualMfaDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.VirtualMFADevice.ReadOnly]
  def listVirtualMFADevicesPaginated(
      request: zio.aws.iam.model.ListVirtualMfaDevicesRequest
  ): IO[AwsError, zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly]
  def deleteLoginProfile(
      request: zio.aws.iam.model.DeleteLoginProfileRequest
  ): IO[AwsError, Unit]
  def listGroupPolicies(
      request: zio.aws.iam.model.ListGroupPoliciesRequest
  ): ZStream[Any, AwsError, PolicyNameType]
  def listGroupPoliciesPaginated(
      request: zio.aws.iam.model.ListGroupPoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly]
  def deleteInstanceProfile(
      request: zio.aws.iam.model.DeleteInstanceProfileRequest
  ): IO[AwsError, Unit]
  def createGroup(
      request: zio.aws.iam.model.CreateGroupRequest
  ): IO[AwsError, zio.aws.iam.model.CreateGroupResponse.ReadOnly]
  def untagMFADevice(
      request: zio.aws.iam.model.UntagMfaDeviceRequest
  ): IO[AwsError, Unit]
  def createAccountAlias(
      request: zio.aws.iam.model.CreateAccountAliasRequest
  ): IO[AwsError, Unit]
  def attachGroupPolicy(
      request: zio.aws.iam.model.AttachGroupPolicyRequest
  ): IO[AwsError, Unit]
  def setSecurityTokenServicePreferences(
      request: zio.aws.iam.model.SetSecurityTokenServicePreferencesRequest
  ): IO[AwsError, Unit]
  def putUserPolicy(
      request: zio.aws.iam.model.PutUserPolicyRequest
  ): IO[AwsError, Unit]
  def listAttachedUserPolicies(
      request: zio.aws.iam.model.ListAttachedUserPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.AttachedPolicy.ReadOnly]
  def listAttachedUserPoliciesPaginated(
      request: zio.aws.iam.model.ListAttachedUserPoliciesRequest
  ): IO[AwsError, zio.aws.iam.model.ListAttachedUserPoliciesResponse.ReadOnly]
  def attachUserPolicy(
      request: zio.aws.iam.model.AttachUserPolicyRequest
  ): IO[AwsError, Unit]
  def deleteServiceLinkedRole(
      request: zio.aws.iam.model.DeleteServiceLinkedRoleRequest
  ): IO[AwsError, zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly]
  def listUserTags(
      request: zio.aws.iam.model.ListUserTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listUserTagsPaginated(
      request: zio.aws.iam.model.ListUserTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListUserTagsResponse.ReadOnly]
  def updateRoleDescription(
      request: zio.aws.iam.model.UpdateRoleDescriptionRequest
  ): IO[AwsError, zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly]
  def updateLoginProfile(
      request: zio.aws.iam.model.UpdateLoginProfileRequest
  ): IO[AwsError, Unit]
  def attachRolePolicy(
      request: zio.aws.iam.model.AttachRolePolicyRequest
  ): IO[AwsError, Unit]
  def tagMFADevice(
      request: zio.aws.iam.model.TagMfaDeviceRequest
  ): IO[AwsError, Unit]
  def updateGroup(
      request: zio.aws.iam.model.UpdateGroupRequest
  ): IO[AwsError, Unit]
  def simulatePrincipalPolicy(
      request: zio.aws.iam.model.SimulatePrincipalPolicyRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.EvaluationResult.ReadOnly]
  def simulatePrincipalPolicyPaginated(
      request: zio.aws.iam.model.SimulatePrincipalPolicyRequest
  ): IO[AwsError, zio.aws.iam.model.SimulatePrincipalPolicyResponse.ReadOnly]
  def updateAccountPasswordPolicy(
      request: zio.aws.iam.model.UpdateAccountPasswordPolicyRequest
  ): IO[AwsError, Unit]
  def listAccountAliases(
      request: zio.aws.iam.model.ListAccountAliasesRequest
  ): ZStream[Any, AwsError, AccountAliasType]
  def listAccountAliasesPaginated(
      request: zio.aws.iam.model.ListAccountAliasesRequest
  ): IO[AwsError, zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly]
  def updateSSHPublicKey(
      request: zio.aws.iam.model.UpdateSshPublicKeyRequest
  ): IO[AwsError, Unit]
  def deactivateMFADevice(
      request: zio.aws.iam.model.DeactivateMfaDeviceRequest
  ): IO[AwsError, Unit]
  def getRole(
      request: zio.aws.iam.model.GetRoleRequest
  ): IO[AwsError, zio.aws.iam.model.GetRoleResponse.ReadOnly]
  def listOpenIDConnectProviderTags(
      request: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listOpenIDConnectProviderTagsPaginated(
      request: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.ListOpenIdConnectProviderTagsResponse.ReadOnly
  ]
  def getInstanceProfile(
      request: zio.aws.iam.model.GetInstanceProfileRequest
  ): IO[AwsError, zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly]
  def createPolicy(
      request: zio.aws.iam.model.CreatePolicyRequest
  ): IO[AwsError, zio.aws.iam.model.CreatePolicyResponse.ReadOnly]
  def getAccountAuthorizationDetails(
      request: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.UserDetail.ReadOnly]
  def getAccountAuthorizationDetailsPaginated(
      request: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly
  ]
  def listPolicyTags(
      request: zio.aws.iam.model.ListPolicyTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listPolicyTagsPaginated(
      request: zio.aws.iam.model.ListPolicyTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly]
  def listMFADevices(
      request: zio.aws.iam.model.ListMfaDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.MFADevice.ReadOnly]
  def listMFADevicesPaginated(
      request: zio.aws.iam.model.ListMfaDevicesRequest
  ): IO[AwsError, zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly]
  def generateCredentialReport(): IO[
    AwsError,
    zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly
  ]
  def listOpenIDConnectProviders(
      request: zio.aws.iam.model.ListOpenIdConnectProvidersRequest
  ): IO[AwsError, zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly]
  def tagSAMLProvider(
      request: zio.aws.iam.model.TagSamlProviderRequest
  ): IO[AwsError, Unit]
  def updateServiceSpecificCredential(
      request: zio.aws.iam.model.UpdateServiceSpecificCredentialRequest
  ): IO[AwsError, Unit]
  def deletePolicy(
      request: zio.aws.iam.model.DeletePolicyRequest
  ): IO[AwsError, Unit]
  def deleteUser(
      request: zio.aws.iam.model.DeleteUserRequest
  ): IO[AwsError, Unit]
  def listRoleTags(
      request: zio.aws.iam.model.ListRoleTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listRoleTagsPaginated(
      request: zio.aws.iam.model.ListRoleTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListRoleTagsResponse.ReadOnly]
  def getGroup(
      request: zio.aws.iam.model.GetGroupRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.User.ReadOnly]
  def getGroupPaginated(
      request: zio.aws.iam.model.GetGroupRequest
  ): IO[AwsError, zio.aws.iam.model.GetGroupResponse.ReadOnly]
  def getPolicy(
      request: zio.aws.iam.model.GetPolicyRequest
  ): IO[AwsError, zio.aws.iam.model.GetPolicyResponse.ReadOnly]
  def listInstanceProfiles(
      request: zio.aws.iam.model.ListInstanceProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.InstanceProfile.ReadOnly]
  def listInstanceProfilesPaginated(
      request: zio.aws.iam.model.ListInstanceProfilesRequest
  ): IO[AwsError, zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly]
  def getOrganizationsAccessReport(
      request: zio.aws.iam.model.GetOrganizationsAccessReportRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly
  ]
  def listInstanceProfileTags(
      request: zio.aws.iam.model.ListInstanceProfileTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listInstanceProfileTagsPaginated(
      request: zio.aws.iam.model.ListInstanceProfileTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListInstanceProfileTagsResponse.ReadOnly]
  def updateSigningCertificate(
      request: zio.aws.iam.model.UpdateSigningCertificateRequest
  ): IO[AwsError, Unit]
  def listInstanceProfilesForRole(
      request: zio.aws.iam.model.ListInstanceProfilesForRoleRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.InstanceProfile.ReadOnly]
  def listInstanceProfilesForRolePaginated(
      request: zio.aws.iam.model.ListInstanceProfilesForRoleRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.ListInstanceProfilesForRoleResponse.ReadOnly
  ]
  def getContextKeysForCustomPolicy(
      request: zio.aws.iam.model.GetContextKeysForCustomPolicyRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly
  ]
  def updateAssumeRolePolicy(
      request: zio.aws.iam.model.UpdateAssumeRolePolicyRequest
  ): IO[AwsError, Unit]
  def getServerCertificate(
      request: zio.aws.iam.model.GetServerCertificateRequest
  ): IO[AwsError, zio.aws.iam.model.GetServerCertificateResponse.ReadOnly]
  def createInstanceProfile(
      request: zio.aws.iam.model.CreateInstanceProfileRequest
  ): IO[AwsError, zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly]
  def listAccessKeys(
      request: zio.aws.iam.model.ListAccessKeysRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.AccessKeyMetadata.ReadOnly]
  def listAccessKeysPaginated(
      request: zio.aws.iam.model.ListAccessKeysRequest
  ): IO[AwsError, zio.aws.iam.model.ListAccessKeysResponse.ReadOnly]
  def getServiceLastAccessedDetailsWithEntities(
      request: zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
  ): IO[
    AwsError,
    zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly
  ]
  def createPolicyVersion(
      request: zio.aws.iam.model.CreatePolicyVersionRequest
  ): IO[AwsError, zio.aws.iam.model.CreatePolicyVersionResponse.ReadOnly]
  def deleteRolePermissionsBoundary(
      request: zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest
  ): IO[AwsError, Unit]
  def deleteSAMLProvider(
      request: zio.aws.iam.model.DeleteSamlProviderRequest
  ): IO[AwsError, Unit]
  def listServerCertificates(
      request: zio.aws.iam.model.ListServerCertificatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
  ]
  def listServerCertificatesPaginated(
      request: zio.aws.iam.model.ListServerCertificatesRequest
  ): IO[AwsError, zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly]
  def getServiceLinkedRoleDeletionStatus(
      request: zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest
  ): IO[AwsError, ReadOnly]
  def tagPolicy(request: zio.aws.iam.model.TagPolicyRequest): IO[AwsError, Unit]
  def getPolicyVersion(
      request: zio.aws.iam.model.GetPolicyVersionRequest
  ): IO[AwsError, zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly]
  def tagUser(request: zio.aws.iam.model.TagUserRequest): IO[AwsError, Unit]
  def getAccessKeyLastUsed(
      request: zio.aws.iam.model.GetAccessKeyLastUsedRequest
  ): IO[AwsError, zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly]
  def untagServerCertificate(
      request: zio.aws.iam.model.UntagServerCertificateRequest
  ): IO[AwsError, Unit]
  def getSAMLProvider(
      request: zio.aws.iam.model.GetSamlProviderRequest
  ): IO[AwsError, zio.aws.iam.model.GetSamlProviderResponse.ReadOnly]
  def listServerCertificateTags(
      request: zio.aws.iam.model.ListServerCertificateTagsRequest
  ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly]
  def listServerCertificateTagsPaginated(
      request: zio.aws.iam.model.ListServerCertificateTagsRequest
  ): IO[AwsError, zio.aws.iam.model.ListServerCertificateTagsResponse.ReadOnly]
  def getCredentialReport()
      : IO[AwsError, zio.aws.iam.model.GetCredentialReportResponse.ReadOnly]
}
object Iam {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Iam] = customized(identity)
  def customized(
      customization: IamAsyncClientBuilder => IamAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Iam] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IamAsyncClientBuilder => IamAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Iam] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IamAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[IamAsyncClient, IamAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[IamAsyncClient, IamAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    );
    client <- ZIO.attempt(
      customization(
        b1.region(_root_.software.amazon.awssdk.regions.Region.AWS_GLOBAL)
      ).build()
    )
  ) yield new IamImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class IamImpl[R](
      override val api: IamAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Iam
      with AwsServiceBase[R] {
    override val serviceName: String = "Iam"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IamImpl[R1] = new IamImpl(api, newAspect, r)
    def getOpenIDConnectProvider(
        request: zio.aws.iam.model.GetOpenIdConnectProviderRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      GetOpenIdConnectProviderRequest,
      GetOpenIdConnectProviderResponse
    ]("getOpenIDConnectProvider", api.getOpenIDConnectProvider)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.GetOpenIdConnectProviderResponse.wrap)
      .provideEnvironment(r)
    def listUserPolicies(
        request: zio.aws.iam.model.ListUserPoliciesRequest
    ): ZStream[Any, AwsError, PolicyNameType] = asyncJavaPaginatedRequest[
      ListUserPoliciesRequest,
      java.lang.String,
      ListUserPoliciesPublisher
    ]("listUserPolicies", api.listUserPoliciesPaginator, _.policyNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.iam.model.primitives.PolicyNameType(item))
      .provideEnvironment(r)
    def listUserPoliciesPaginated(
        request: zio.aws.iam.model.ListUserPoliciesRequest
    ): IO[AwsError, zio.aws.iam.model.ListUserPoliciesResponse.ReadOnly] =
      asyncRequestResponse[ListUserPoliciesRequest, ListUserPoliciesResponse](
        "listUserPolicies",
        api.listUserPolicies
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListUserPoliciesResponse.wrap)
        .provideEnvironment(r)
    def deleteAccountAlias(
        request: zio.aws.iam.model.DeleteAccountAliasRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAccountAliasRequest,
      DeleteAccountAliasResponse
    ]("deleteAccountAlias", api.deleteAccountAlias)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteRolePolicy(
        request: zio.aws.iam.model.DeleteRolePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRolePolicyRequest, DeleteRolePolicyResponse](
        "deleteRolePolicy",
        api.deleteRolePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def uploadSSHPublicKey(
        request: zio.aws.iam.model.UploadSshPublicKeyRequest
    ): IO[AwsError, zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly] =
      asyncRequestResponse[
        UploadSshPublicKeyRequest,
        UploadSshPublicKeyResponse
      ]("uploadSSHPublicKey", api.uploadSSHPublicKey)(request.buildAwsValue())
        .map(zio.aws.iam.model.UploadSshPublicKeyResponse.wrap)
        .provideEnvironment(r)
    def deleteOpenIDConnectProvider(
        request: zio.aws.iam.model.DeleteOpenIdConnectProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteOpenIdConnectProviderRequest,
      DeleteOpenIdConnectProviderResponse
    ]("deleteOpenIDConnectProvider", api.deleteOpenIDConnectProvider)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listUsers(
        request: zio.aws.iam.model.ListUsersRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.User.ReadOnly] =
      asyncJavaPaginatedRequest[ListUsersRequest, User, ListUsersPublisher](
        "listUsers",
        api.listUsersPaginator,
        _.users()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.User.wrap(item))
        .provideEnvironment(r)
    def listUsersPaginated(
        request: zio.aws.iam.model.ListUsersRequest
    ): IO[AwsError, zio.aws.iam.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[ListUsersRequest, ListUsersResponse](
        "listUsers",
        api.listUsers
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def tagServerCertificate(
        request: zio.aws.iam.model.TagServerCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      TagServerCertificateRequest,
      TagServerCertificateResponse
    ]("tagServerCertificate", api.tagServerCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagRole(request: zio.aws.iam.model.TagRoleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[TagRoleRequest, TagRoleResponse](
        "tagRole",
        api.tagRole
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateUser(
        request: zio.aws.iam.model.UpdateUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateUserRequest, UpdateUserResponse](
        "updateUser",
        api.updateUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateSAMLProvider(
        request: zio.aws.iam.model.UpdateSamlProviderRequest
    ): IO[AwsError, zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateSamlProviderRequest,
        UpdateSamlProviderResponse
      ]("updateSAMLProvider", api.updateSAMLProvider)(request.buildAwsValue())
        .map(zio.aws.iam.model.UpdateSamlProviderResponse.wrap)
        .provideEnvironment(r)
    def untagInstanceProfile(
        request: zio.aws.iam.model.UntagInstanceProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UntagInstanceProfileRequest,
      UntagInstanceProfileResponse
    ]("untagInstanceProfile", api.untagInstanceProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createSAMLProvider(
        request: zio.aws.iam.model.CreateSamlProviderRequest
    ): IO[AwsError, zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly] =
      asyncRequestResponse[
        CreateSamlProviderRequest,
        CreateSamlProviderResponse
      ]("createSAMLProvider", api.createSAMLProvider)(request.buildAwsValue())
        .map(zio.aws.iam.model.CreateSamlProviderResponse.wrap)
        .provideEnvironment(r)
    def enableMFADevice(
        request: zio.aws.iam.model.EnableMfaDeviceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[EnableMfaDeviceRequest, EnableMfaDeviceResponse](
        "enableMFADevice",
        api.enableMFADevice
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def removeClientIDFromOpenIDConnectProvider(
        request: zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveClientIdFromOpenIdConnectProviderRequest,
      RemoveClientIdFromOpenIdConnectProviderResponse
    ](
      "removeClientIDFromOpenIDConnectProvider",
      api.removeClientIDFromOpenIDConnectProvider
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def addClientIDToOpenIDConnectProvider(
        request: zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AddClientIdToOpenIdConnectProviderRequest,
      AddClientIdToOpenIdConnectProviderResponse
    ](
      "addClientIDToOpenIDConnectProvider",
      api.addClientIDToOpenIDConnectProvider
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listSSHPublicKeys(
        request: zio.aws.iam.model.ListSshPublicKeysRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListSshPublicKeysRequest,
        SSHPublicKeyMetadata,
        ListSSHPublicKeysPublisher
      ]("listSSHPublicKeys", api.listSSHPublicKeysPaginator, _.sshPublicKeys())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.SSHPublicKeyMetadata.wrap(item))
        .provideEnvironment(r)
    def listSSHPublicKeysPaginated(
        request: zio.aws.iam.model.ListSshPublicKeysRequest
    ): IO[AwsError, zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly] =
      asyncRequestResponse[ListSshPublicKeysRequest, ListSshPublicKeysResponse](
        "listSSHPublicKeys",
        api.listSSHPublicKeys
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListSshPublicKeysResponse.wrap)
        .provideEnvironment(r)
    def getLoginProfile(
        request: zio.aws.iam.model.GetLoginProfileRequest
    ): IO[AwsError, zio.aws.iam.model.GetLoginProfileResponse.ReadOnly] =
      asyncRequestResponse[GetLoginProfileRequest, GetLoginProfileResponse](
        "getLoginProfile",
        api.getLoginProfile
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetLoginProfileResponse.wrap)
        .provideEnvironment(r)
    def uploadSigningCertificate(
        request: zio.aws.iam.model.UploadSigningCertificateRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      UploadSigningCertificateRequest,
      UploadSigningCertificateResponse
    ]("uploadSigningCertificate", api.uploadSigningCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.UploadSigningCertificateResponse.wrap)
      .provideEnvironment(r)
    def detachRolePolicy(
        request: zio.aws.iam.model.DetachRolePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DetachRolePolicyRequest, DetachRolePolicyResponse](
        "detachRolePolicy",
        api.detachRolePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def resyncMFADevice(
        request: zio.aws.iam.model.ResyncMfaDeviceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[ResyncMfaDeviceRequest, ResyncMfaDeviceResponse](
        "resyncMFADevice",
        api.resyncMFADevice
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listServiceSpecificCredentials(
        request: zio.aws.iam.model.ListServiceSpecificCredentialsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListServiceSpecificCredentialsRequest,
      ListServiceSpecificCredentialsResponse
    ]("listServiceSpecificCredentials", api.listServiceSpecificCredentials)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListServiceSpecificCredentialsResponse.wrap)
      .provideEnvironment(r)
    def listAttachedRolePolicies(
        request: zio.aws.iam.model.ListAttachedRolePoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.AttachedPolicy.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAttachedRolePoliciesRequest,
        AttachedPolicy,
        ListAttachedRolePoliciesPublisher
      ](
        "listAttachedRolePolicies",
        api.listAttachedRolePoliciesPaginator,
        _.attachedPolicies()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.AttachedPolicy.wrap(item))
        .provideEnvironment(r)
    def listAttachedRolePoliciesPaginated(
        request: zio.aws.iam.model.ListAttachedRolePoliciesRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAttachedRolePoliciesRequest,
      ListAttachedRolePoliciesResponse
    ]("listAttachedRolePolicies", api.listAttachedRolePolicies)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListAttachedRolePoliciesResponse.wrap)
      .provideEnvironment(r)
    def getSSHPublicKey(
        request: zio.aws.iam.model.GetSshPublicKeyRequest
    ): IO[AwsError, zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly] =
      asyncRequestResponse[GetSshPublicKeyRequest, GetSshPublicKeyResponse](
        "getSSHPublicKey",
        api.getSSHPublicKey
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetSshPublicKeyResponse.wrap)
        .provideEnvironment(r)
    def untagSAMLProvider(
        request: zio.aws.iam.model.UntagSamlProviderRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagSamlProviderRequest, UntagSamlProviderResponse](
        "untagSAMLProvider",
        api.untagSAMLProvider
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def simulateCustomPolicy(
        request: zio.aws.iam.model.SimulateCustomPolicyRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.EvaluationResult.ReadOnly] =
      asyncJavaPaginatedRequest[
        SimulateCustomPolicyRequest,
        EvaluationResult,
        SimulateCustomPolicyPublisher
      ](
        "simulateCustomPolicy",
        api.simulateCustomPolicyPaginator,
        _.evaluationResults()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.EvaluationResult.wrap(item))
        .provideEnvironment(r)
    def simulateCustomPolicyPaginated(
        request: zio.aws.iam.model.SimulateCustomPolicyRequest
    ): IO[AwsError, zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        SimulateCustomPolicyRequest,
        SimulateCustomPolicyResponse
      ]("simulateCustomPolicy", api.simulateCustomPolicy)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.SimulateCustomPolicyResponse.wrap)
        .provideEnvironment(r)
    def deleteAccessKey(
        request: zio.aws.iam.model.DeleteAccessKeyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAccessKeyRequest, DeleteAccessKeyResponse](
        "deleteAccessKey",
        api.deleteAccessKey
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getServiceLastAccessedDetails(
        request: zio.aws.iam.model.GetServiceLastAccessedDetailsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetServiceLastAccessedDetailsRequest,
      GetServiceLastAccessedDetailsResponse
    ]("getServiceLastAccessedDetails", api.getServiceLastAccessedDetails)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.wrap)
      .provideEnvironment(r)
    def deleteUserPolicy(
        request: zio.aws.iam.model.DeleteUserPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteUserPolicyRequest, DeleteUserPolicyResponse](
        "deleteUserPolicy",
        api.deleteUserPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def untagUser(
        request: zio.aws.iam.model.UntagUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagUserRequest, UntagUserResponse](
        "untagUser",
        api.untagUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createServiceSpecificCredential(
        request: zio.aws.iam.model.CreateServiceSpecificCredentialRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateServiceSpecificCredentialRequest,
      CreateServiceSpecificCredentialResponse
    ]("createServiceSpecificCredential", api.createServiceSpecificCredential)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.CreateServiceSpecificCredentialResponse.wrap)
      .provideEnvironment(r)
    def listSAMLProviders(
        request: zio.aws.iam.model.ListSamlProvidersRequest
    ): IO[AwsError, zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly] =
      asyncRequestResponse[ListSamlProvidersRequest, ListSamlProvidersResponse](
        "listSAMLProviders",
        api.listSAMLProviders
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListSamlProvidersResponse.wrap)
        .provideEnvironment(r)
    def listPoliciesGrantingServiceAccess(
        request: zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPoliciesGrantingServiceAccessRequest,
      ListPoliciesGrantingServiceAccessResponse
    ](
      "listPoliciesGrantingServiceAccess",
      api.listPoliciesGrantingServiceAccess
    )(request.buildAwsValue())
      .map(zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.wrap)
      .provideEnvironment(r)
    def getGroupPolicy(
        request: zio.aws.iam.model.GetGroupPolicyRequest
    ): IO[AwsError, zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetGroupPolicyRequest, GetGroupPolicyResponse](
        "getGroupPolicy",
        api.getGroupPolicy
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetGroupPolicyResponse.wrap)
        .provideEnvironment(r)
    def uploadServerCertificate(
        request: zio.aws.iam.model.UploadServerCertificateRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      UploadServerCertificateRequest,
      UploadServerCertificateResponse
    ]("uploadServerCertificate", api.uploadServerCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.UploadServerCertificateResponse.wrap)
      .provideEnvironment(r)
    def updateServerCertificate(
        request: zio.aws.iam.model.UpdateServerCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateServerCertificateRequest,
      UpdateServerCertificateResponse
    ]("updateServerCertificate", api.updateServerCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteGroup(
        request: zio.aws.iam.model.DeleteGroupRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteGroupRequest, DeleteGroupResponse](
        "deleteGroup",
        api.deleteGroup
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def removeRoleFromInstanceProfile(
        request: zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveRoleFromInstanceProfileRequest,
      RemoveRoleFromInstanceProfileResponse
    ]("removeRoleFromInstanceProfile", api.removeRoleFromInstanceProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createRole(
        request: zio.aws.iam.model.CreateRoleRequest
    ): IO[AwsError, zio.aws.iam.model.CreateRoleResponse.ReadOnly] =
      asyncRequestResponse[CreateRoleRequest, CreateRoleResponse](
        "createRole",
        api.createRole
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.CreateRoleResponse.wrap)
        .provideEnvironment(r)
    def getAccountSummary()
        : IO[AwsError, zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly] =
      asyncRequestResponse[GetAccountSummaryRequest, GetAccountSummaryResponse](
        "getAccountSummary",
        api.getAccountSummary
      )(GetAccountSummaryRequest.builder().build())
        .map(zio.aws.iam.model.GetAccountSummaryResponse.wrap)
        .provideEnvironment(r)
    def getMFADevice(
        request: zio.aws.iam.model.GetMfaDeviceRequest
    ): IO[AwsError, zio.aws.iam.model.GetMfaDeviceResponse.ReadOnly] =
      asyncRequestResponse[GetMfaDeviceRequest, GetMfaDeviceResponse](
        "getMFADevice",
        api.getMFADevice
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetMfaDeviceResponse.wrap)
        .provideEnvironment(r)
    def changePassword(
        request: zio.aws.iam.model.ChangePasswordRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[ChangePasswordRequest, ChangePasswordResponse](
        "changePassword",
        api.changePassword
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listRolePolicies(
        request: zio.aws.iam.model.ListRolePoliciesRequest
    ): ZStream[Any, AwsError, PolicyNameType] = asyncJavaPaginatedRequest[
      ListRolePoliciesRequest,
      java.lang.String,
      ListRolePoliciesPublisher
    ]("listRolePolicies", api.listRolePoliciesPaginator, _.policyNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.iam.model.primitives.PolicyNameType(item))
      .provideEnvironment(r)
    def listRolePoliciesPaginated(
        request: zio.aws.iam.model.ListRolePoliciesRequest
    ): IO[AwsError, zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly] =
      asyncRequestResponse[ListRolePoliciesRequest, ListRolePoliciesResponse](
        "listRolePolicies",
        api.listRolePolicies
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListRolePoliciesResponse.wrap)
        .provideEnvironment(r)
    def detachGroupPolicy(
        request: zio.aws.iam.model.DetachGroupPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DetachGroupPolicyRequest, DetachGroupPolicyResponse](
        "detachGroupPolicy",
        api.detachGroupPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listGroupsForUser(
        request: zio.aws.iam.model.ListGroupsForUserRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Group.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListGroupsForUserRequest,
        Group,
        ListGroupsForUserPublisher
      ]("listGroupsForUser", api.listGroupsForUserPaginator, _.groups())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Group.wrap(item)).provideEnvironment(r)
    def listGroupsForUserPaginated(
        request: zio.aws.iam.model.ListGroupsForUserRequest
    ): IO[AwsError, zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly] =
      asyncRequestResponse[ListGroupsForUserRequest, ListGroupsForUserResponse](
        "listGroupsForUser",
        api.listGroupsForUser
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListGroupsForUserResponse.wrap)
        .provideEnvironment(r)
    def deleteVirtualMFADevice(
        request: zio.aws.iam.model.DeleteVirtualMfaDeviceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteVirtualMfaDeviceRequest,
      DeleteVirtualMfaDeviceResponse
    ]("deleteVirtualMFADevice", api.deleteVirtualMFADevice)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listAttachedGroupPolicies(
        request: zio.aws.iam.model.ListAttachedGroupPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.AttachedPolicy.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAttachedGroupPoliciesRequest,
        AttachedPolicy,
        ListAttachedGroupPoliciesPublisher
      ](
        "listAttachedGroupPolicies",
        api.listAttachedGroupPoliciesPaginator,
        _.attachedPolicies()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.AttachedPolicy.wrap(item))
        .provideEnvironment(r)
    def listAttachedGroupPoliciesPaginated(
        request: zio.aws.iam.model.ListAttachedGroupPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListAttachedGroupPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAttachedGroupPoliciesRequest,
      ListAttachedGroupPoliciesResponse
    ]("listAttachedGroupPolicies", api.listAttachedGroupPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListAttachedGroupPoliciesResponse.wrap)
      .provideEnvironment(r)
    def getUser(
        request: zio.aws.iam.model.GetUserRequest
    ): IO[AwsError, zio.aws.iam.model.GetUserResponse.ReadOnly] =
      asyncRequestResponse[GetUserRequest, GetUserResponse](
        "getUser",
        api.getUser
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetUserResponse.wrap)
        .provideEnvironment(r)
    def deleteAccountPasswordPolicy(): IO[AwsError, Unit] =
      asyncRequestResponse[
        DeleteAccountPasswordPolicyRequest,
        DeleteAccountPasswordPolicyResponse
      ]("deleteAccountPasswordPolicy", api.deleteAccountPasswordPolicy)(
        DeleteAccountPasswordPolicyRequest.builder().build()
      ).unit.provideEnvironment(r)
    def getContextKeysForPrincipalPolicy(
        request: zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetContextKeysForPrincipalPolicyRequest,
      GetContextKeysForPrincipalPolicyResponse
    ]("getContextKeysForPrincipalPolicy", api.getContextKeysForPrincipalPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.wrap)
      .provideEnvironment(r)
    def listGroups(
        request: zio.aws.iam.model.ListGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Group.ReadOnly] =
      asyncJavaPaginatedRequest[ListGroupsRequest, Group, ListGroupsPublisher](
        "listGroups",
        api.listGroupsPaginator,
        _.groups()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.Group.wrap(item))
        .provideEnvironment(r)
    def listGroupsPaginated(
        request: zio.aws.iam.model.ListGroupsRequest
    ): IO[AwsError, zio.aws.iam.model.ListGroupsResponse.ReadOnly] =
      asyncRequestResponse[ListGroupsRequest, ListGroupsResponse](
        "listGroups",
        api.listGroups
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListGroupsResponse.wrap)
        .provideEnvironment(r)
    def listPolicyVersions(
        request: zio.aws.iam.model.ListPolicyVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.PolicyVersion.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListPolicyVersionsRequest,
        PolicyVersion,
        ListPolicyVersionsPublisher
      ]("listPolicyVersions", api.listPolicyVersionsPaginator, _.versions())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.PolicyVersion.wrap(item))
        .provideEnvironment(r)
    def listPolicyVersionsPaginated(
        request: zio.aws.iam.model.ListPolicyVersionsRequest
    ): IO[AwsError, zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        ListPolicyVersionsRequest,
        ListPolicyVersionsResponse
      ]("listPolicyVersions", api.listPolicyVersions)(request.buildAwsValue())
        .map(zio.aws.iam.model.ListPolicyVersionsResponse.wrap)
        .provideEnvironment(r)
    def getRolePolicy(
        request: zio.aws.iam.model.GetRolePolicyRequest
    ): IO[AwsError, zio.aws.iam.model.GetRolePolicyResponse.ReadOnly] =
      asyncRequestResponse[GetRolePolicyRequest, GetRolePolicyResponse](
        "getRolePolicy",
        api.getRolePolicy
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetRolePolicyResponse.wrap)
        .provideEnvironment(r)
    def tagOpenIDConnectProvider(
        request: zio.aws.iam.model.TagOpenIdConnectProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      TagOpenIdConnectProviderRequest,
      TagOpenIdConnectProviderResponse
    ]("tagOpenIDConnectProvider", api.tagOpenIDConnectProvider)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteRole(
        request: zio.aws.iam.model.DeleteRoleRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRoleRequest, DeleteRoleResponse](
        "deleteRole",
        api.deleteRole
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateOpenIDConnectProviderThumbprint(
        request: zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateOpenIdConnectProviderThumbprintRequest,
      UpdateOpenIdConnectProviderThumbprintResponse
    ](
      "updateOpenIDConnectProviderThumbprint",
      api.updateOpenIDConnectProviderThumbprint
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def untagPolicy(
        request: zio.aws.iam.model.UntagPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagPolicyRequest, UntagPolicyResponse](
        "untagPolicy",
        api.untagPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def detachUserPolicy(
        request: zio.aws.iam.model.DetachUserPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DetachUserPolicyRequest, DetachUserPolicyResponse](
        "detachUserPolicy",
        api.detachUserPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listEntitiesForPolicy(
        request: zio.aws.iam.model.ListEntitiesForPolicyRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.PolicyGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListEntitiesForPolicyRequest,
        PolicyGroup,
        ListEntitiesForPolicyPublisher
      ](
        "listEntitiesForPolicy",
        api.listEntitiesForPolicyPaginator,
        _.policyGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.PolicyGroup.wrap(item))
        .provideEnvironment(r)
    def listEntitiesForPolicyPaginated(
        request: zio.aws.iam.model.ListEntitiesForPolicyRequest
    ): IO[AwsError, zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        ListEntitiesForPolicyRequest,
        ListEntitiesForPolicyResponse
      ]("listEntitiesForPolicy", api.listEntitiesForPolicy)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.ListEntitiesForPolicyResponse.wrap)
        .provideEnvironment(r)
    def listMFADeviceTags(
        request: zio.aws.iam.model.ListMfaDeviceTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListMfaDeviceTagsRequest,
        Tag,
        ListMFADeviceTagsPublisher
      ]("listMFADeviceTags", api.listMFADeviceTagsPaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Tag.wrap(item)).provideEnvironment(r)
    def listMFADeviceTagsPaginated(
        request: zio.aws.iam.model.ListMfaDeviceTagsRequest
    ): IO[AwsError, zio.aws.iam.model.ListMfaDeviceTagsResponse.ReadOnly] =
      asyncRequestResponse[ListMfaDeviceTagsRequest, ListMfaDeviceTagsResponse](
        "listMFADeviceTags",
        api.listMFADeviceTags
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListMfaDeviceTagsResponse.wrap)
        .provideEnvironment(r)
    def deleteSSHPublicKey(
        request: zio.aws.iam.model.DeleteSshPublicKeyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSshPublicKeyRequest,
      DeleteSshPublicKeyResponse
    ]("deleteSSHPublicKey", api.deleteSSHPublicKey)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createUser(
        request: zio.aws.iam.model.CreateUserRequest
    ): IO[AwsError, zio.aws.iam.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[CreateUserRequest, CreateUserResponse](
        "createUser",
        api.createUser
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def deleteSigningCertificate(
        request: zio.aws.iam.model.DeleteSigningCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSigningCertificateRequest,
      DeleteSigningCertificateResponse
    ]("deleteSigningCertificate", api.deleteSigningCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def setDefaultPolicyVersion(
        request: zio.aws.iam.model.SetDefaultPolicyVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      SetDefaultPolicyVersionRequest,
      SetDefaultPolicyVersionResponse
    ]("setDefaultPolicyVersion", api.setDefaultPolicyVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateRole(
        request: zio.aws.iam.model.UpdateRoleRequest
    ): IO[AwsError, zio.aws.iam.model.UpdateRoleResponse.ReadOnly] =
      asyncRequestResponse[UpdateRoleRequest, UpdateRoleResponse](
        "updateRole",
        api.updateRole
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.UpdateRoleResponse.wrap)
        .provideEnvironment(r)
    def listSAMLProviderTags(
        request: zio.aws.iam.model.ListSamlProviderTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListSamlProviderTagsRequest,
        Tag,
        ListSAMLProviderTagsPublisher
      ]("listSAMLProviderTags", api.listSAMLProviderTagsPaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Tag.wrap(item)).provideEnvironment(r)
    def listSAMLProviderTagsPaginated(
        request: zio.aws.iam.model.ListSamlProviderTagsRequest
    ): IO[AwsError, zio.aws.iam.model.ListSamlProviderTagsResponse.ReadOnly] =
      asyncRequestResponse[
        ListSamlProviderTagsRequest,
        ListSamlProviderTagsResponse
      ]("listSAMLProviderTags", api.listSAMLProviderTags)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.ListSamlProviderTagsResponse.wrap)
        .provideEnvironment(r)
    def createServiceLinkedRole(
        request: zio.aws.iam.model.CreateServiceLinkedRoleRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateServiceLinkedRoleRequest,
      CreateServiceLinkedRoleResponse
    ]("createServiceLinkedRole", api.createServiceLinkedRole)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.CreateServiceLinkedRoleResponse.wrap)
      .provideEnvironment(r)
    def addUserToGroup(
        request: zio.aws.iam.model.AddUserToGroupRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AddUserToGroupRequest, AddUserToGroupResponse](
        "addUserToGroup",
        api.addUserToGroup
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteServiceSpecificCredential(
        request: zio.aws.iam.model.DeleteServiceSpecificCredentialRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteServiceSpecificCredentialRequest,
      DeleteServiceSpecificCredentialResponse
    ]("deleteServiceSpecificCredential", api.deleteServiceSpecificCredential)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putRolePermissionsBoundary(
        request: zio.aws.iam.model.PutRolePermissionsBoundaryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutRolePermissionsBoundaryRequest,
      PutRolePermissionsBoundaryResponse
    ]("putRolePermissionsBoundary", api.putRolePermissionsBoundary)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteUserPermissionsBoundary(
        request: zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteUserPermissionsBoundaryRequest,
      DeleteUserPermissionsBoundaryResponse
    ]("deleteUserPermissionsBoundary", api.deleteUserPermissionsBoundary)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putRolePolicy(
        request: zio.aws.iam.model.PutRolePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutRolePolicyRequest, PutRolePolicyResponse](
        "putRolePolicy",
        api.putRolePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listSigningCertificates(
        request: zio.aws.iam.model.ListSigningCertificatesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.SigningCertificate.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListSigningCertificatesRequest,
        SigningCertificate,
        ListSigningCertificatesPublisher
      ](
        "listSigningCertificates",
        api.listSigningCertificatesPaginator,
        _.certificates()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.SigningCertificate.wrap(item))
        .provideEnvironment(r)
    def listSigningCertificatesPaginated(
        request: zio.aws.iam.model.ListSigningCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSigningCertificatesRequest,
      ListSigningCertificatesResponse
    ]("listSigningCertificates", api.listSigningCertificates)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListSigningCertificatesResponse.wrap)
      .provideEnvironment(r)
    def createAccessKey(
        request: zio.aws.iam.model.CreateAccessKeyRequest
    ): IO[AwsError, zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly] =
      asyncRequestResponse[CreateAccessKeyRequest, CreateAccessKeyResponse](
        "createAccessKey",
        api.createAccessKey
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.CreateAccessKeyResponse.wrap)
        .provideEnvironment(r)
    def untagOpenIDConnectProvider(
        request: zio.aws.iam.model.UntagOpenIdConnectProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UntagOpenIdConnectProviderRequest,
      UntagOpenIdConnectProviderResponse
    ]("untagOpenIDConnectProvider", api.untagOpenIDConnectProvider)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagInstanceProfile(
        request: zio.aws.iam.model.TagInstanceProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      TagInstanceProfileRequest,
      TagInstanceProfileResponse
    ]("tagInstanceProfile", api.tagInstanceProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listRoles(
        request: zio.aws.iam.model.ListRolesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Role.ReadOnly] =
      asyncJavaPaginatedRequest[ListRolesRequest, Role, ListRolesPublisher](
        "listRoles",
        api.listRolesPaginator,
        _.roles()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.Role.wrap(item))
        .provideEnvironment(r)
    def listRolesPaginated(
        request: zio.aws.iam.model.ListRolesRequest
    ): IO[AwsError, zio.aws.iam.model.ListRolesResponse.ReadOnly] =
      asyncRequestResponse[ListRolesRequest, ListRolesResponse](
        "listRoles",
        api.listRoles
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListRolesResponse.wrap)
        .provideEnvironment(r)
    def listPolicies(
        request: zio.aws.iam.model.ListPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Policy.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListPoliciesRequest,
        Policy,
        ListPoliciesPublisher
      ]("listPolicies", api.listPoliciesPaginator, _.policies())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Policy.wrap(item)).provideEnvironment(r)
    def listPoliciesPaginated(
        request: zio.aws.iam.model.ListPoliciesRequest
    ): IO[AwsError, zio.aws.iam.model.ListPoliciesResponse.ReadOnly] =
      asyncRequestResponse[ListPoliciesRequest, ListPoliciesResponse](
        "listPolicies",
        api.listPolicies
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListPoliciesResponse.wrap)
        .provideEnvironment(r)
    def putGroupPolicy(
        request: zio.aws.iam.model.PutGroupPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutGroupPolicyRequest, PutGroupPolicyResponse](
        "putGroupPolicy",
        api.putGroupPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createLoginProfile(
        request: zio.aws.iam.model.CreateLoginProfileRequest
    ): IO[AwsError, zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly] =
      asyncRequestResponse[
        CreateLoginProfileRequest,
        CreateLoginProfileResponse
      ]("createLoginProfile", api.createLoginProfile)(request.buildAwsValue())
        .map(zio.aws.iam.model.CreateLoginProfileResponse.wrap)
        .provideEnvironment(r)
    def deleteGroupPolicy(
        request: zio.aws.iam.model.DeleteGroupPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteGroupPolicyRequest, DeleteGroupPolicyResponse](
        "deleteGroupPolicy",
        api.deleteGroupPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createOpenIDConnectProvider(
        request: zio.aws.iam.model.CreateOpenIdConnectProviderRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateOpenIdConnectProviderRequest,
      CreateOpenIdConnectProviderResponse
    ]("createOpenIDConnectProvider", api.createOpenIDConnectProvider)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.CreateOpenIdConnectProviderResponse.wrap)
      .provideEnvironment(r)
    def generateOrganizationsAccessReport(
        request: zio.aws.iam.model.GenerateOrganizationsAccessReportRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GenerateOrganizationsAccessReportRequest,
      GenerateOrganizationsAccessReportResponse
    ](
      "generateOrganizationsAccessReport",
      api.generateOrganizationsAccessReport
    )(request.buildAwsValue())
      .map(zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.wrap)
      .provideEnvironment(r)
    def generateServiceLastAccessedDetails(
        request: zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      GenerateServiceLastAccessedDetailsRequest,
      GenerateServiceLastAccessedDetailsResponse
    ](
      "generateServiceLastAccessedDetails",
      api.generateServiceLastAccessedDetails
    )(request.buildAwsValue())
      .map(zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.wrap)
      .provideEnvironment(r)
    def getUserPolicy(
        request: zio.aws.iam.model.GetUserPolicyRequest
    ): IO[AwsError, zio.aws.iam.model.GetUserPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetUserPolicyRequest, GetUserPolicyResponse](
        "getUserPolicy",
        api.getUserPolicy
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetUserPolicyResponse.wrap)
        .provideEnvironment(r)
    def getAccountPasswordPolicy(): IO[
      AwsError,
      zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccountPasswordPolicyRequest,
      GetAccountPasswordPolicyResponse
    ]("getAccountPasswordPolicy", api.getAccountPasswordPolicy)(
      GetAccountPasswordPolicyRequest.builder().build()
    ).map(zio.aws.iam.model.GetAccountPasswordPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateAccessKey(
        request: zio.aws.iam.model.UpdateAccessKeyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateAccessKeyRequest, UpdateAccessKeyResponse](
        "updateAccessKey",
        api.updateAccessKey
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deletePolicyVersion(
        request: zio.aws.iam.model.DeletePolicyVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeletePolicyVersionRequest,
      DeletePolicyVersionResponse
    ]("deletePolicyVersion", api.deletePolicyVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createVirtualMFADevice(
        request: zio.aws.iam.model.CreateVirtualMfaDeviceRequest
    ): IO[AwsError, zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly] =
      asyncRequestResponse[
        CreateVirtualMfaDeviceRequest,
        CreateVirtualMfaDeviceResponse
      ]("createVirtualMFADevice", api.createVirtualMFADevice)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.CreateVirtualMfaDeviceResponse.wrap)
        .provideEnvironment(r)
    def removeUserFromGroup(
        request: zio.aws.iam.model.RemoveUserFromGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveUserFromGroupRequest,
      RemoveUserFromGroupResponse
    ]("removeUserFromGroup", api.removeUserFromGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteServerCertificate(
        request: zio.aws.iam.model.DeleteServerCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteServerCertificateRequest,
      DeleteServerCertificateResponse
    ]("deleteServerCertificate", api.deleteServerCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def untagRole(
        request: zio.aws.iam.model.UntagRoleRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagRoleRequest, UntagRoleResponse](
        "untagRole",
        api.untagRole
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def addRoleToInstanceProfile(
        request: zio.aws.iam.model.AddRoleToInstanceProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AddRoleToInstanceProfileRequest,
      AddRoleToInstanceProfileResponse
    ]("addRoleToInstanceProfile", api.addRoleToInstanceProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putUserPermissionsBoundary(
        request: zio.aws.iam.model.PutUserPermissionsBoundaryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutUserPermissionsBoundaryRequest,
      PutUserPermissionsBoundaryResponse
    ]("putUserPermissionsBoundary", api.putUserPermissionsBoundary)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def resetServiceSpecificCredential(
        request: zio.aws.iam.model.ResetServiceSpecificCredentialRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly
    ] = asyncRequestResponse[
      ResetServiceSpecificCredentialRequest,
      ResetServiceSpecificCredentialResponse
    ]("resetServiceSpecificCredential", api.resetServiceSpecificCredential)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ResetServiceSpecificCredentialResponse.wrap)
      .provideEnvironment(r)
    def listVirtualMFADevices(
        request: zio.aws.iam.model.ListVirtualMfaDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.VirtualMFADevice.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListVirtualMfaDevicesRequest,
        VirtualMFADevice,
        ListVirtualMFADevicesPublisher
      ](
        "listVirtualMFADevices",
        api.listVirtualMFADevicesPaginator,
        _.virtualMFADevices()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.VirtualMFADevice.wrap(item))
        .provideEnvironment(r)
    def listVirtualMFADevicesPaginated(
        request: zio.aws.iam.model.ListVirtualMfaDevicesRequest
    ): IO[AwsError, zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly] =
      asyncRequestResponse[
        ListVirtualMfaDevicesRequest,
        ListVirtualMfaDevicesResponse
      ]("listVirtualMFADevices", api.listVirtualMFADevices)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.ListVirtualMfaDevicesResponse.wrap)
        .provideEnvironment(r)
    def deleteLoginProfile(
        request: zio.aws.iam.model.DeleteLoginProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteLoginProfileRequest,
      DeleteLoginProfileResponse
    ]("deleteLoginProfile", api.deleteLoginProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listGroupPolicies(
        request: zio.aws.iam.model.ListGroupPoliciesRequest
    ): ZStream[Any, AwsError, PolicyNameType] = asyncJavaPaginatedRequest[
      ListGroupPoliciesRequest,
      java.lang.String,
      ListGroupPoliciesPublisher
    ]("listGroupPolicies", api.listGroupPoliciesPaginator, _.policyNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.iam.model.primitives.PolicyNameType(item))
      .provideEnvironment(r)
    def listGroupPoliciesPaginated(
        request: zio.aws.iam.model.ListGroupPoliciesRequest
    ): IO[AwsError, zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly] =
      asyncRequestResponse[ListGroupPoliciesRequest, ListGroupPoliciesResponse](
        "listGroupPolicies",
        api.listGroupPolicies
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListGroupPoliciesResponse.wrap)
        .provideEnvironment(r)
    def deleteInstanceProfile(
        request: zio.aws.iam.model.DeleteInstanceProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteInstanceProfileRequest,
      DeleteInstanceProfileResponse
    ]("deleteInstanceProfile", api.deleteInstanceProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createGroup(
        request: zio.aws.iam.model.CreateGroupRequest
    ): IO[AwsError, zio.aws.iam.model.CreateGroupResponse.ReadOnly] =
      asyncRequestResponse[CreateGroupRequest, CreateGroupResponse](
        "createGroup",
        api.createGroup
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.CreateGroupResponse.wrap)
        .provideEnvironment(r)
    def untagMFADevice(
        request: zio.aws.iam.model.UntagMfaDeviceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagMfaDeviceRequest, UntagMfaDeviceResponse](
        "untagMFADevice",
        api.untagMFADevice
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createAccountAlias(
        request: zio.aws.iam.model.CreateAccountAliasRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      CreateAccountAliasRequest,
      CreateAccountAliasResponse
    ]("createAccountAlias", api.createAccountAlias)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def attachGroupPolicy(
        request: zio.aws.iam.model.AttachGroupPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AttachGroupPolicyRequest, AttachGroupPolicyResponse](
        "attachGroupPolicy",
        api.attachGroupPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def setSecurityTokenServicePreferences(
        request: zio.aws.iam.model.SetSecurityTokenServicePreferencesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      SetSecurityTokenServicePreferencesRequest,
      SetSecurityTokenServicePreferencesResponse
    ](
      "setSecurityTokenServicePreferences",
      api.setSecurityTokenServicePreferences
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putUserPolicy(
        request: zio.aws.iam.model.PutUserPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutUserPolicyRequest, PutUserPolicyResponse](
        "putUserPolicy",
        api.putUserPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listAttachedUserPolicies(
        request: zio.aws.iam.model.ListAttachedUserPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.AttachedPolicy.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAttachedUserPoliciesRequest,
        AttachedPolicy,
        ListAttachedUserPoliciesPublisher
      ](
        "listAttachedUserPolicies",
        api.listAttachedUserPoliciesPaginator,
        _.attachedPolicies()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.AttachedPolicy.wrap(item))
        .provideEnvironment(r)
    def listAttachedUserPoliciesPaginated(
        request: zio.aws.iam.model.ListAttachedUserPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListAttachedUserPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAttachedUserPoliciesRequest,
      ListAttachedUserPoliciesResponse
    ]("listAttachedUserPolicies", api.listAttachedUserPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListAttachedUserPoliciesResponse.wrap)
      .provideEnvironment(r)
    def attachUserPolicy(
        request: zio.aws.iam.model.AttachUserPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AttachUserPolicyRequest, AttachUserPolicyResponse](
        "attachUserPolicy",
        api.attachUserPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteServiceLinkedRole(
        request: zio.aws.iam.model.DeleteServiceLinkedRoleRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteServiceLinkedRoleRequest,
      DeleteServiceLinkedRoleResponse
    ]("deleteServiceLinkedRole", api.deleteServiceLinkedRole)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.DeleteServiceLinkedRoleResponse.wrap)
      .provideEnvironment(r)
    def listUserTags(
        request: zio.aws.iam.model.ListUserTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListUserTagsRequest,
        Tag,
        ListUserTagsPublisher
      ]("listUserTags", api.listUserTagsPaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Tag.wrap(item)).provideEnvironment(r)
    def listUserTagsPaginated(
        request: zio.aws.iam.model.ListUserTagsRequest
    ): IO[AwsError, zio.aws.iam.model.ListUserTagsResponse.ReadOnly] =
      asyncRequestResponse[ListUserTagsRequest, ListUserTagsResponse](
        "listUserTags",
        api.listUserTags
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListUserTagsResponse.wrap)
        .provideEnvironment(r)
    def updateRoleDescription(
        request: zio.aws.iam.model.UpdateRoleDescriptionRequest
    ): IO[AwsError, zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateRoleDescriptionRequest,
        UpdateRoleDescriptionResponse
      ]("updateRoleDescription", api.updateRoleDescription)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.UpdateRoleDescriptionResponse.wrap)
        .provideEnvironment(r)
    def updateLoginProfile(
        request: zio.aws.iam.model.UpdateLoginProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateLoginProfileRequest,
      UpdateLoginProfileResponse
    ]("updateLoginProfile", api.updateLoginProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def attachRolePolicy(
        request: zio.aws.iam.model.AttachRolePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AttachRolePolicyRequest, AttachRolePolicyResponse](
        "attachRolePolicy",
        api.attachRolePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def tagMFADevice(
        request: zio.aws.iam.model.TagMfaDeviceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagMfaDeviceRequest, TagMfaDeviceResponse](
        "tagMFADevice",
        api.tagMFADevice
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateGroup(
        request: zio.aws.iam.model.UpdateGroupRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateGroupRequest, UpdateGroupResponse](
        "updateGroup",
        api.updateGroup
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def simulatePrincipalPolicy(
        request: zio.aws.iam.model.SimulatePrincipalPolicyRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.EvaluationResult.ReadOnly] =
      asyncJavaPaginatedRequest[
        SimulatePrincipalPolicyRequest,
        EvaluationResult,
        SimulatePrincipalPolicyPublisher
      ](
        "simulatePrincipalPolicy",
        api.simulatePrincipalPolicyPaginator,
        _.evaluationResults()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.EvaluationResult.wrap(item))
        .provideEnvironment(r)
    def simulatePrincipalPolicyPaginated(
        request: zio.aws.iam.model.SimulatePrincipalPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.SimulatePrincipalPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      SimulatePrincipalPolicyRequest,
      SimulatePrincipalPolicyResponse
    ]("simulatePrincipalPolicy", api.simulatePrincipalPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.SimulatePrincipalPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateAccountPasswordPolicy(
        request: zio.aws.iam.model.UpdateAccountPasswordPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateAccountPasswordPolicyRequest,
      UpdateAccountPasswordPolicyResponse
    ]("updateAccountPasswordPolicy", api.updateAccountPasswordPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listAccountAliases(
        request: zio.aws.iam.model.ListAccountAliasesRequest
    ): ZStream[Any, AwsError, AccountAliasType] = asyncJavaPaginatedRequest[
      ListAccountAliasesRequest,
      java.lang.String,
      ListAccountAliasesPublisher
    ](
      "listAccountAliases",
      api.listAccountAliasesPaginator,
      _.accountAliases()
    )(request.buildAwsValue())
      .map(item => zio.aws.iam.model.primitives.AccountAliasType(item))
      .provideEnvironment(r)
    def listAccountAliasesPaginated(
        request: zio.aws.iam.model.ListAccountAliasesRequest
    ): IO[AwsError, zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly] =
      asyncRequestResponse[
        ListAccountAliasesRequest,
        ListAccountAliasesResponse
      ]("listAccountAliases", api.listAccountAliases)(request.buildAwsValue())
        .map(zio.aws.iam.model.ListAccountAliasesResponse.wrap)
        .provideEnvironment(r)
    def updateSSHPublicKey(
        request: zio.aws.iam.model.UpdateSshPublicKeyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateSshPublicKeyRequest,
      UpdateSshPublicKeyResponse
    ]("updateSSHPublicKey", api.updateSSHPublicKey)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deactivateMFADevice(
        request: zio.aws.iam.model.DeactivateMfaDeviceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeactivateMfaDeviceRequest,
      DeactivateMfaDeviceResponse
    ]("deactivateMFADevice", api.deactivateMFADevice)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getRole(
        request: zio.aws.iam.model.GetRoleRequest
    ): IO[AwsError, zio.aws.iam.model.GetRoleResponse.ReadOnly] =
      asyncRequestResponse[GetRoleRequest, GetRoleResponse](
        "getRole",
        api.getRole
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetRoleResponse.wrap)
        .provideEnvironment(r)
    def listOpenIDConnectProviderTags(
        request: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListOpenIdConnectProviderTagsRequest,
        Tag,
        ListOpenIDConnectProviderTagsPublisher
      ](
        "listOpenIDConnectProviderTags",
        api.listOpenIDConnectProviderTagsPaginator,
        _.tags()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listOpenIDConnectProviderTagsPaginated(
        request: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListOpenIdConnectProviderTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListOpenIdConnectProviderTagsRequest,
      ListOpenIdConnectProviderTagsResponse
    ]("listOpenIDConnectProviderTags", api.listOpenIDConnectProviderTags)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListOpenIdConnectProviderTagsResponse.wrap)
      .provideEnvironment(r)
    def getInstanceProfile(
        request: zio.aws.iam.model.GetInstanceProfileRequest
    ): IO[AwsError, zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly] =
      asyncRequestResponse[
        GetInstanceProfileRequest,
        GetInstanceProfileResponse
      ]("getInstanceProfile", api.getInstanceProfile)(request.buildAwsValue())
        .map(zio.aws.iam.model.GetInstanceProfileResponse.wrap)
        .provideEnvironment(r)
    def createPolicy(
        request: zio.aws.iam.model.CreatePolicyRequest
    ): IO[AwsError, zio.aws.iam.model.CreatePolicyResponse.ReadOnly] =
      asyncRequestResponse[CreatePolicyRequest, CreatePolicyResponse](
        "createPolicy",
        api.createPolicy
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.CreatePolicyResponse.wrap)
        .provideEnvironment(r)
    def getAccountAuthorizationDetails(
        request: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.UserDetail.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetAccountAuthorizationDetailsRequest,
        UserDetail,
        GetAccountAuthorizationDetailsPublisher
      ](
        "getAccountAuthorizationDetails",
        api.getAccountAuthorizationDetailsPaginator,
        _.userDetailList()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.UserDetail.wrap(item))
        .provideEnvironment(r)
    def getAccountAuthorizationDetailsPaginated(
        request: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccountAuthorizationDetailsRequest,
      GetAccountAuthorizationDetailsResponse
    ]("getAccountAuthorizationDetails", api.getAccountAuthorizationDetails)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.wrap)
      .provideEnvironment(r)
    def listPolicyTags(
        request: zio.aws.iam.model.ListPolicyTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListPolicyTagsRequest,
        Tag,
        ListPolicyTagsPublisher
      ]("listPolicyTags", api.listPolicyTagsPaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Tag.wrap(item)).provideEnvironment(r)
    def listPolicyTagsPaginated(
        request: zio.aws.iam.model.ListPolicyTagsRequest
    ): IO[AwsError, zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly] =
      asyncRequestResponse[ListPolicyTagsRequest, ListPolicyTagsResponse](
        "listPolicyTags",
        api.listPolicyTags
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListPolicyTagsResponse.wrap)
        .provideEnvironment(r)
    def listMFADevices(
        request: zio.aws.iam.model.ListMfaDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.MFADevice.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListMfaDevicesRequest,
        MFADevice,
        ListMFADevicesPublisher
      ]("listMFADevices", api.listMFADevicesPaginator, _.mfaDevices())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.MFADevice.wrap(item))
        .provideEnvironment(r)
    def listMFADevicesPaginated(
        request: zio.aws.iam.model.ListMfaDevicesRequest
    ): IO[AwsError, zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly] =
      asyncRequestResponse[ListMfaDevicesRequest, ListMfaDevicesResponse](
        "listMFADevices",
        api.listMFADevices
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListMfaDevicesResponse.wrap)
        .provideEnvironment(r)
    def generateCredentialReport(): IO[
      AwsError,
      zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GenerateCredentialReportRequest,
      GenerateCredentialReportResponse
    ]("generateCredentialReport", api.generateCredentialReport)(
      GenerateCredentialReportRequest.builder().build()
    ).map(zio.aws.iam.model.GenerateCredentialReportResponse.wrap)
      .provideEnvironment(r)
    def listOpenIDConnectProviders(
        request: zio.aws.iam.model.ListOpenIdConnectProvidersRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      ListOpenIdConnectProvidersRequest,
      ListOpenIdConnectProvidersResponse
    ]("listOpenIDConnectProviders", api.listOpenIDConnectProviders)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListOpenIdConnectProvidersResponse.wrap)
      .provideEnvironment(r)
    def tagSAMLProvider(
        request: zio.aws.iam.model.TagSamlProviderRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagSamlProviderRequest, TagSamlProviderResponse](
        "tagSAMLProvider",
        api.tagSAMLProvider
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateServiceSpecificCredential(
        request: zio.aws.iam.model.UpdateServiceSpecificCredentialRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateServiceSpecificCredentialRequest,
      UpdateServiceSpecificCredentialResponse
    ]("updateServiceSpecificCredential", api.updateServiceSpecificCredential)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deletePolicy(
        request: zio.aws.iam.model.DeletePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeletePolicyRequest, DeletePolicyResponse](
        "deletePolicy",
        api.deletePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteUser(
        request: zio.aws.iam.model.DeleteUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteUserRequest, DeleteUserResponse](
        "deleteUser",
        api.deleteUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listRoleTags(
        request: zio.aws.iam.model.ListRoleTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListRoleTagsRequest,
        Tag,
        ListRoleTagsPublisher
      ]("listRoleTags", api.listRoleTagsPaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.Tag.wrap(item)).provideEnvironment(r)
    def listRoleTagsPaginated(
        request: zio.aws.iam.model.ListRoleTagsRequest
    ): IO[AwsError, zio.aws.iam.model.ListRoleTagsResponse.ReadOnly] =
      asyncRequestResponse[ListRoleTagsRequest, ListRoleTagsResponse](
        "listRoleTags",
        api.listRoleTags
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListRoleTagsResponse.wrap)
        .provideEnvironment(r)
    def getGroup(
        request: zio.aws.iam.model.GetGroupRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.User.ReadOnly] =
      asyncJavaPaginatedRequest[GetGroupRequest, User, GetGroupPublisher](
        "getGroup",
        api.getGroupPaginator,
        _.users()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.User.wrap(item))
        .provideEnvironment(r)
    def getGroupPaginated(
        request: zio.aws.iam.model.GetGroupRequest
    ): IO[AwsError, zio.aws.iam.model.GetGroupResponse.ReadOnly] =
      asyncRequestResponse[GetGroupRequest, GetGroupResponse](
        "getGroup",
        api.getGroup
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetGroupResponse.wrap)
        .provideEnvironment(r)
    def getPolicy(
        request: zio.aws.iam.model.GetPolicyRequest
    ): IO[AwsError, zio.aws.iam.model.GetPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetPolicyRequest, GetPolicyResponse](
        "getPolicy",
        api.getPolicy
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetPolicyResponse.wrap)
        .provideEnvironment(r)
    def listInstanceProfiles(
        request: zio.aws.iam.model.ListInstanceProfilesRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.InstanceProfile.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListInstanceProfilesRequest,
        InstanceProfile,
        ListInstanceProfilesPublisher
      ](
        "listInstanceProfiles",
        api.listInstanceProfilesPaginator,
        _.instanceProfiles()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.InstanceProfile.wrap(item))
        .provideEnvironment(r)
    def listInstanceProfilesPaginated(
        request: zio.aws.iam.model.ListInstanceProfilesRequest
    ): IO[AwsError, zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly] =
      asyncRequestResponse[
        ListInstanceProfilesRequest,
        ListInstanceProfilesResponse
      ]("listInstanceProfiles", api.listInstanceProfiles)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.ListInstanceProfilesResponse.wrap)
        .provideEnvironment(r)
    def getOrganizationsAccessReport(
        request: zio.aws.iam.model.GetOrganizationsAccessReportRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GetOrganizationsAccessReportRequest,
      GetOrganizationsAccessReportResponse
    ]("getOrganizationsAccessReport", api.getOrganizationsAccessReport)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.GetOrganizationsAccessReportResponse.wrap)
      .provideEnvironment(r)
    def listInstanceProfileTags(
        request: zio.aws.iam.model.ListInstanceProfileTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListInstanceProfileTagsRequest,
        Tag,
        ListInstanceProfileTagsPublisher
      ](
        "listInstanceProfileTags",
        api.listInstanceProfileTagsPaginator,
        _.tags()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listInstanceProfileTagsPaginated(
        request: zio.aws.iam.model.ListInstanceProfileTagsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListInstanceProfileTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListInstanceProfileTagsRequest,
      ListInstanceProfileTagsResponse
    ]("listInstanceProfileTags", api.listInstanceProfileTags)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListInstanceProfileTagsResponse.wrap)
      .provideEnvironment(r)
    def updateSigningCertificate(
        request: zio.aws.iam.model.UpdateSigningCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateSigningCertificateRequest,
      UpdateSigningCertificateResponse
    ]("updateSigningCertificate", api.updateSigningCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listInstanceProfilesForRole(
        request: zio.aws.iam.model.ListInstanceProfilesForRoleRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.InstanceProfile.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListInstanceProfilesForRoleRequest,
        InstanceProfile,
        ListInstanceProfilesForRolePublisher
      ](
        "listInstanceProfilesForRole",
        api.listInstanceProfilesForRolePaginator,
        _.instanceProfiles()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.InstanceProfile.wrap(item))
        .provideEnvironment(r)
    def listInstanceProfilesForRolePaginated(
        request: zio.aws.iam.model.ListInstanceProfilesForRoleRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListInstanceProfilesForRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      ListInstanceProfilesForRoleRequest,
      ListInstanceProfilesForRoleResponse
    ]("listInstanceProfilesForRole", api.listInstanceProfilesForRole)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListInstanceProfilesForRoleResponse.wrap)
      .provideEnvironment(r)
    def getContextKeysForCustomPolicy(
        request: zio.aws.iam.model.GetContextKeysForCustomPolicyRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetContextKeysForCustomPolicyRequest,
      GetContextKeysForCustomPolicyResponse
    ]("getContextKeysForCustomPolicy", api.getContextKeysForCustomPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.wrap)
      .provideEnvironment(r)
    def updateAssumeRolePolicy(
        request: zio.aws.iam.model.UpdateAssumeRolePolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateAssumeRolePolicyRequest,
      UpdateAssumeRolePolicyResponse
    ]("updateAssumeRolePolicy", api.updateAssumeRolePolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getServerCertificate(
        request: zio.aws.iam.model.GetServerCertificateRequest
    ): IO[AwsError, zio.aws.iam.model.GetServerCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        GetServerCertificateRequest,
        GetServerCertificateResponse
      ]("getServerCertificate", api.getServerCertificate)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.GetServerCertificateResponse.wrap)
        .provideEnvironment(r)
    def createInstanceProfile(
        request: zio.aws.iam.model.CreateInstanceProfileRequest
    ): IO[AwsError, zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly] =
      asyncRequestResponse[
        CreateInstanceProfileRequest,
        CreateInstanceProfileResponse
      ]("createInstanceProfile", api.createInstanceProfile)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.CreateInstanceProfileResponse.wrap)
        .provideEnvironment(r)
    def listAccessKeys(
        request: zio.aws.iam.model.ListAccessKeysRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.AccessKeyMetadata.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAccessKeysRequest,
        AccessKeyMetadata,
        ListAccessKeysPublisher
      ]("listAccessKeys", api.listAccessKeysPaginator, _.accessKeyMetadata())(
        request.buildAwsValue()
      ).map(item => zio.aws.iam.model.AccessKeyMetadata.wrap(item))
        .provideEnvironment(r)
    def listAccessKeysPaginated(
        request: zio.aws.iam.model.ListAccessKeysRequest
    ): IO[AwsError, zio.aws.iam.model.ListAccessKeysResponse.ReadOnly] =
      asyncRequestResponse[ListAccessKeysRequest, ListAccessKeysResponse](
        "listAccessKeys",
        api.listAccessKeys
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.ListAccessKeysResponse.wrap)
        .provideEnvironment(r)
    def getServiceLastAccessedDetailsWithEntities(
        request: zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetServiceLastAccessedDetailsWithEntitiesRequest,
      GetServiceLastAccessedDetailsWithEntitiesResponse
    ](
      "getServiceLastAccessedDetailsWithEntities",
      api.getServiceLastAccessedDetailsWithEntities
    )(request.buildAwsValue())
      .map(
        zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.wrap
      )
      .provideEnvironment(r)
    def createPolicyVersion(
        request: zio.aws.iam.model.CreatePolicyVersionRequest
    ): IO[AwsError, zio.aws.iam.model.CreatePolicyVersionResponse.ReadOnly] =
      asyncRequestResponse[
        CreatePolicyVersionRequest,
        CreatePolicyVersionResponse
      ]("createPolicyVersion", api.createPolicyVersion)(request.buildAwsValue())
        .map(zio.aws.iam.model.CreatePolicyVersionResponse.wrap)
        .provideEnvironment(r)
    def deleteRolePermissionsBoundary(
        request: zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRolePermissionsBoundaryRequest,
      DeleteRolePermissionsBoundaryResponse
    ]("deleteRolePermissionsBoundary", api.deleteRolePermissionsBoundary)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteSAMLProvider(
        request: zio.aws.iam.model.DeleteSamlProviderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSamlProviderRequest,
      DeleteSamlProviderResponse
    ]("deleteSAMLProvider", api.deleteSAMLProvider)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listServerCertificates(
        request: zio.aws.iam.model.ListServerCertificatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListServerCertificatesRequest,
      ServerCertificateMetadata,
      ListServerCertificatesPublisher
    ](
      "listServerCertificates",
      api.listServerCertificatesPaginator,
      _.serverCertificateMetadataList()
    )(request.buildAwsValue())
      .map(item => zio.aws.iam.model.ServerCertificateMetadata.wrap(item))
      .provideEnvironment(r)
    def listServerCertificatesPaginated(
        request: zio.aws.iam.model.ListServerCertificatesRequest
    ): IO[AwsError, zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        ListServerCertificatesRequest,
        ListServerCertificatesResponse
      ]("listServerCertificates", api.listServerCertificates)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.ListServerCertificatesResponse.wrap)
        .provideEnvironment(r)
    def getServiceLinkedRoleDeletionStatus(
        request: zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetServiceLinkedRoleDeletionStatusRequest,
      GetServiceLinkedRoleDeletionStatusResponse
    ](
      "getServiceLinkedRoleDeletionStatus",
      api.getServiceLinkedRoleDeletionStatus
    )(request.buildAwsValue())
      .map(zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse.wrap)
      .provideEnvironment(r)
    def tagPolicy(
        request: zio.aws.iam.model.TagPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagPolicyRequest, TagPolicyResponse](
        "tagPolicy",
        api.tagPolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getPolicyVersion(
        request: zio.aws.iam.model.GetPolicyVersionRequest
    ): IO[AwsError, zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly] =
      asyncRequestResponse[GetPolicyVersionRequest, GetPolicyVersionResponse](
        "getPolicyVersion",
        api.getPolicyVersion
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetPolicyVersionResponse.wrap)
        .provideEnvironment(r)
    def tagUser(request: zio.aws.iam.model.TagUserRequest): IO[AwsError, Unit] =
      asyncRequestResponse[TagUserRequest, TagUserResponse](
        "tagUser",
        api.tagUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getAccessKeyLastUsed(
        request: zio.aws.iam.model.GetAccessKeyLastUsedRequest
    ): IO[AwsError, zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly] =
      asyncRequestResponse[
        GetAccessKeyLastUsedRequest,
        GetAccessKeyLastUsedResponse
      ]("getAccessKeyLastUsed", api.getAccessKeyLastUsed)(
        request.buildAwsValue()
      ).map(zio.aws.iam.model.GetAccessKeyLastUsedResponse.wrap)
        .provideEnvironment(r)
    def untagServerCertificate(
        request: zio.aws.iam.model.UntagServerCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UntagServerCertificateRequest,
      UntagServerCertificateResponse
    ]("untagServerCertificate", api.untagServerCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getSAMLProvider(
        request: zio.aws.iam.model.GetSamlProviderRequest
    ): IO[AwsError, zio.aws.iam.model.GetSamlProviderResponse.ReadOnly] =
      asyncRequestResponse[GetSamlProviderRequest, GetSamlProviderResponse](
        "getSAMLProvider",
        api.getSAMLProvider
      )(request.buildAwsValue())
        .map(zio.aws.iam.model.GetSamlProviderResponse.wrap)
        .provideEnvironment(r)
    def listServerCertificateTags(
        request: zio.aws.iam.model.ListServerCertificateTagsRequest
    ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListServerCertificateTagsRequest,
        Tag,
        ListServerCertificateTagsPublisher
      ](
        "listServerCertificateTags",
        api.listServerCertificateTagsPaginator,
        _.tags()
      )(request.buildAwsValue())
        .map(item => zio.aws.iam.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listServerCertificateTagsPaginated(
        request: zio.aws.iam.model.ListServerCertificateTagsRequest
    ): IO[
      AwsError,
      zio.aws.iam.model.ListServerCertificateTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListServerCertificateTagsRequest,
      ListServerCertificateTagsResponse
    ]("listServerCertificateTags", api.listServerCertificateTags)(
      request.buildAwsValue()
    ).map(zio.aws.iam.model.ListServerCertificateTagsResponse.wrap)
      .provideEnvironment(r)
    def getCredentialReport()
        : IO[AwsError, zio.aws.iam.model.GetCredentialReportResponse.ReadOnly] =
      asyncRequestResponse[
        GetCredentialReportRequest,
        GetCredentialReportResponse
      ]("getCredentialReport", api.getCredentialReport)(
        GetCredentialReportRequest.builder().build()
      ).map(zio.aws.iam.model.GetCredentialReportResponse.wrap)
        .provideEnvironment(r)
  }
  def getOpenIDConnectProvider(
      request: zio.aws.iam.model.GetOpenIdConnectProviderRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOpenIDConnectProvider(request))
  def listUserPolicies(
      request: zio.aws.iam.model.ListUserPoliciesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, PolicyNameType] =
    ZStream.serviceWithStream(_.listUserPolicies(request))
  def listUserPoliciesPaginated(
      request: zio.aws.iam.model.ListUserPoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListUserPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserPoliciesPaginated(request))
  def deleteAccountAlias(
      request: zio.aws.iam.model.DeleteAccountAliasRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccountAlias(request))
  def deleteRolePolicy(
      request: zio.aws.iam.model.DeleteRolePolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRolePolicy(request))
  def uploadSSHPublicKey(
      request: zio.aws.iam.model.UploadSshPublicKeyRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadSSHPublicKey(request))
  def deleteOpenIDConnectProvider(
      request: zio.aws.iam.model.DeleteOpenIdConnectProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteOpenIDConnectProvider(request))
  def listUsers(
      request: zio.aws.iam.model.ListUsersRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.User.ReadOnly] =
    ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(request: zio.aws.iam.model.ListUsersRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def tagServerCertificate(
      request: zio.aws.iam.model.TagServerCertificateRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagServerCertificate(request))
  def tagRole(
      request: zio.aws.iam.model.TagRoleRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagRole(request))
  def updateUser(
      request: zio.aws.iam.model.UpdateUserRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateUser(request))
  def updateSAMLProvider(
      request: zio.aws.iam.model.UpdateSamlProviderRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSAMLProvider(request))
  def untagInstanceProfile(
      request: zio.aws.iam.model.UntagInstanceProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagInstanceProfile(request))
  def createSAMLProvider(
      request: zio.aws.iam.model.CreateSamlProviderRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSAMLProvider(request))
  def enableMFADevice(
      request: zio.aws.iam.model.EnableMfaDeviceRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableMFADevice(request))
  def removeClientIDFromOpenIDConnectProvider(
      request: zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeClientIDFromOpenIDConnectProvider(request))
  def addClientIDToOpenIDConnectProvider(
      request: zio.aws.iam.model.AddClientIdToOpenIdConnectProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addClientIDToOpenIDConnectProvider(request))
  def listSSHPublicKeys(
      request: zio.aws.iam.model.ListSshPublicKeysRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listSSHPublicKeys(request))
  def listSSHPublicKeysPaginated(
      request: zio.aws.iam.model.ListSshPublicKeysRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSSHPublicKeysPaginated(request))
  def getLoginProfile(request: zio.aws.iam.model.GetLoginProfileRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetLoginProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoginProfile(request))
  def uploadSigningCertificate(
      request: zio.aws.iam.model.UploadSigningCertificateRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadSigningCertificate(request))
  def detachRolePolicy(
      request: zio.aws.iam.model.DetachRolePolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachRolePolicy(request))
  def resyncMFADevice(
      request: zio.aws.iam.model.ResyncMfaDeviceRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resyncMFADevice(request))
  def listServiceSpecificCredentials(
      request: zio.aws.iam.model.ListServiceSpecificCredentialsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceSpecificCredentials(request))
  def listAttachedRolePolicies(
      request: zio.aws.iam.model.ListAttachedRolePoliciesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.AttachedPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttachedRolePolicies(request))
  def listAttachedRolePoliciesPaginated(
      request: zio.aws.iam.model.ListAttachedRolePoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachedRolePoliciesPaginated(request))
  def getSSHPublicKey(request: zio.aws.iam.model.GetSshPublicKeyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSSHPublicKey(request))
  def untagSAMLProvider(
      request: zio.aws.iam.model.UntagSamlProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagSAMLProvider(request))
  def simulateCustomPolicy(
      request: zio.aws.iam.model.SimulateCustomPolicyRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.EvaluationResult.ReadOnly
  ] = ZStream.serviceWithStream(_.simulateCustomPolicy(request))
  def simulateCustomPolicyPaginated(
      request: zio.aws.iam.model.SimulateCustomPolicyRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.simulateCustomPolicyPaginated(request))
  def deleteAccessKey(
      request: zio.aws.iam.model.DeleteAccessKeyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessKey(request))
  def getServiceLastAccessedDetails(
      request: zio.aws.iam.model.GetServiceLastAccessedDetailsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceLastAccessedDetails(request))
  def deleteUserPolicy(
      request: zio.aws.iam.model.DeleteUserPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUserPolicy(request))
  def untagUser(
      request: zio.aws.iam.model.UntagUserRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagUser(request))
  def createServiceSpecificCredential(
      request: zio.aws.iam.model.CreateServiceSpecificCredentialRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceSpecificCredential(request))
  def listSAMLProviders(
      request: zio.aws.iam.model.ListSamlProvidersRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSAMLProviders(request))
  def listPoliciesGrantingServiceAccess(
      request: zio.aws.iam.model.ListPoliciesGrantingServiceAccessRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPoliciesGrantingServiceAccess(request))
  def getGroupPolicy(request: zio.aws.iam.model.GetGroupPolicyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupPolicy(request))
  def uploadServerCertificate(
      request: zio.aws.iam.model.UploadServerCertificateRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadServerCertificate(request))
  def updateServerCertificate(
      request: zio.aws.iam.model.UpdateServerCertificateRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateServerCertificate(request))
  def deleteGroup(
      request: zio.aws.iam.model.DeleteGroupRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteGroup(request))
  def removeRoleFromInstanceProfile(
      request: zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeRoleFromInstanceProfile(request))
  def createRole(request: zio.aws.iam.model.CreateRoleRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRole(request))
  def getAccountSummary(): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSummary())
  def getMFADevice(request: zio.aws.iam.model.GetMfaDeviceRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetMfaDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMFADevice(request))
  def changePassword(
      request: zio.aws.iam.model.ChangePasswordRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.changePassword(request))
  def listRolePolicies(
      request: zio.aws.iam.model.ListRolePoliciesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, PolicyNameType] =
    ZStream.serviceWithStream(_.listRolePolicies(request))
  def listRolePoliciesPaginated(
      request: zio.aws.iam.model.ListRolePoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRolePoliciesPaginated(request))
  def detachGroupPolicy(
      request: zio.aws.iam.model.DetachGroupPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachGroupPolicy(request))
  def listGroupsForUser(
      request: zio.aws.iam.model.ListGroupsForUserRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Group.ReadOnly] =
    ZStream.serviceWithStream(_.listGroupsForUser(request))
  def listGroupsForUserPaginated(
      request: zio.aws.iam.model.ListGroupsForUserRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupsForUserPaginated(request))
  def deleteVirtualMFADevice(
      request: zio.aws.iam.model.DeleteVirtualMfaDeviceRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVirtualMFADevice(request))
  def listAttachedGroupPolicies(
      request: zio.aws.iam.model.ListAttachedGroupPoliciesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.AttachedPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttachedGroupPolicies(request))
  def listAttachedGroupPoliciesPaginated(
      request: zio.aws.iam.model.ListAttachedGroupPoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListAttachedGroupPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachedGroupPoliciesPaginated(request))
  def getUser(request: zio.aws.iam.model.GetUserRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUser(request))
  def deleteAccountPasswordPolicy(): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccountPasswordPolicy())
  def getContextKeysForPrincipalPolicy(
      request: zio.aws.iam.model.GetContextKeysForPrincipalPolicyRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContextKeysForPrincipalPolicy(request))
  def listGroups(
      request: zio.aws.iam.model.ListGroupsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Group.ReadOnly] =
    ZStream.serviceWithStream(_.listGroups(request))
  def listGroupsPaginated(request: zio.aws.iam.model.ListGroupsRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupsPaginated(request))
  def listPolicyVersions(
      request: zio.aws.iam.model.ListPolicyVersionsRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.PolicyVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listPolicyVersions(request))
  def listPolicyVersionsPaginated(
      request: zio.aws.iam.model.ListPolicyVersionsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPolicyVersionsPaginated(request))
  def getRolePolicy(request: zio.aws.iam.model.GetRolePolicyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetRolePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRolePolicy(request))
  def tagOpenIDConnectProvider(
      request: zio.aws.iam.model.TagOpenIdConnectProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagOpenIDConnectProvider(request))
  def deleteRole(
      request: zio.aws.iam.model.DeleteRoleRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRole(request))
  def updateOpenIDConnectProviderThumbprint(
      request: zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateOpenIDConnectProviderThumbprint(request))
  def untagPolicy(
      request: zio.aws.iam.model.UntagPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagPolicy(request))
  def detachUserPolicy(
      request: zio.aws.iam.model.DetachUserPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachUserPolicy(request))
  def listEntitiesForPolicy(
      request: zio.aws.iam.model.ListEntitiesForPolicyRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.PolicyGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listEntitiesForPolicy(request))
  def listEntitiesForPolicyPaginated(
      request: zio.aws.iam.model.ListEntitiesForPolicyRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEntitiesForPolicyPaginated(request))
  def listMFADeviceTags(
      request: zio.aws.iam.model.ListMfaDeviceTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listMFADeviceTags(request))
  def listMFADeviceTagsPaginated(
      request: zio.aws.iam.model.ListMfaDeviceTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListMfaDeviceTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMFADeviceTagsPaginated(request))
  def deleteSSHPublicKey(
      request: zio.aws.iam.model.DeleteSshPublicKeyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSSHPublicKey(request))
  def createUser(request: zio.aws.iam.model.CreateUserRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def deleteSigningCertificate(
      request: zio.aws.iam.model.DeleteSigningCertificateRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSigningCertificate(request))
  def setDefaultPolicyVersion(
      request: zio.aws.iam.model.SetDefaultPolicyVersionRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setDefaultPolicyVersion(request))
  def updateRole(request: zio.aws.iam.model.UpdateRoleRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.UpdateRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRole(request))
  def listSAMLProviderTags(
      request: zio.aws.iam.model.ListSamlProviderTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listSAMLProviderTags(request))
  def listSAMLProviderTagsPaginated(
      request: zio.aws.iam.model.ListSamlProviderTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListSamlProviderTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSAMLProviderTagsPaginated(request))
  def createServiceLinkedRole(
      request: zio.aws.iam.model.CreateServiceLinkedRoleRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceLinkedRole(request))
  def addUserToGroup(
      request: zio.aws.iam.model.AddUserToGroupRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addUserToGroup(request))
  def deleteServiceSpecificCredential(
      request: zio.aws.iam.model.DeleteServiceSpecificCredentialRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteServiceSpecificCredential(request))
  def putRolePermissionsBoundary(
      request: zio.aws.iam.model.PutRolePermissionsBoundaryRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putRolePermissionsBoundary(request))
  def deleteUserPermissionsBoundary(
      request: zio.aws.iam.model.DeleteUserPermissionsBoundaryRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUserPermissionsBoundary(request))
  def putRolePolicy(
      request: zio.aws.iam.model.PutRolePolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putRolePolicy(request))
  def listSigningCertificates(
      request: zio.aws.iam.model.ListSigningCertificatesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.SigningCertificate.ReadOnly
  ] = ZStream.serviceWithStream(_.listSigningCertificates(request))
  def listSigningCertificatesPaginated(
      request: zio.aws.iam.model.ListSigningCertificatesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSigningCertificatesPaginated(request))
  def createAccessKey(request: zio.aws.iam.model.CreateAccessKeyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessKey(request))
  def untagOpenIDConnectProvider(
      request: zio.aws.iam.model.UntagOpenIdConnectProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagOpenIDConnectProvider(request))
  def tagInstanceProfile(
      request: zio.aws.iam.model.TagInstanceProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagInstanceProfile(request))
  def listRoles(
      request: zio.aws.iam.model.ListRolesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Role.ReadOnly] =
    ZStream.serviceWithStream(_.listRoles(request))
  def listRolesPaginated(request: zio.aws.iam.model.ListRolesRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListRolesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRolesPaginated(request))
  def listPolicies(
      request: zio.aws.iam.model.ListPoliciesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Policy.ReadOnly] =
    ZStream.serviceWithStream(_.listPolicies(request))
  def listPoliciesPaginated(
      request: zio.aws.iam.model.ListPoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPoliciesPaginated(request))
  def putGroupPolicy(
      request: zio.aws.iam.model.PutGroupPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putGroupPolicy(request))
  def createLoginProfile(
      request: zio.aws.iam.model.CreateLoginProfileRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoginProfile(request))
  def deleteGroupPolicy(
      request: zio.aws.iam.model.DeleteGroupPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteGroupPolicy(request))
  def createOpenIDConnectProvider(
      request: zio.aws.iam.model.CreateOpenIdConnectProviderRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOpenIDConnectProvider(request))
  def generateOrganizationsAccessReport(
      request: zio.aws.iam.model.GenerateOrganizationsAccessReportRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateOrganizationsAccessReport(request))
  def generateServiceLastAccessedDetails(
      request: zio.aws.iam.model.GenerateServiceLastAccessedDetailsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateServiceLastAccessedDetails(request))
  def getUserPolicy(request: zio.aws.iam.model.GetUserPolicyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetUserPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserPolicy(request))
  def getAccountPasswordPolicy(): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountPasswordPolicy())
  def updateAccessKey(
      request: zio.aws.iam.model.UpdateAccessKeyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAccessKey(request))
  def deletePolicyVersion(
      request: zio.aws.iam.model.DeletePolicyVersionRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePolicyVersion(request))
  def createVirtualMFADevice(
      request: zio.aws.iam.model.CreateVirtualMfaDeviceRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVirtualMFADevice(request))
  def removeUserFromGroup(
      request: zio.aws.iam.model.RemoveUserFromGroupRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeUserFromGroup(request))
  def deleteServerCertificate(
      request: zio.aws.iam.model.DeleteServerCertificateRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteServerCertificate(request))
  def untagRole(
      request: zio.aws.iam.model.UntagRoleRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagRole(request))
  def addRoleToInstanceProfile(
      request: zio.aws.iam.model.AddRoleToInstanceProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addRoleToInstanceProfile(request))
  def putUserPermissionsBoundary(
      request: zio.aws.iam.model.PutUserPermissionsBoundaryRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putUserPermissionsBoundary(request))
  def resetServiceSpecificCredential(
      request: zio.aws.iam.model.ResetServiceSpecificCredentialRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetServiceSpecificCredential(request))
  def listVirtualMFADevices(
      request: zio.aws.iam.model.ListVirtualMfaDevicesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.VirtualMFADevice.ReadOnly
  ] = ZStream.serviceWithStream(_.listVirtualMFADevices(request))
  def listVirtualMFADevicesPaginated(
      request: zio.aws.iam.model.ListVirtualMfaDevicesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualMFADevicesPaginated(request))
  def deleteLoginProfile(
      request: zio.aws.iam.model.DeleteLoginProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLoginProfile(request))
  def listGroupPolicies(
      request: zio.aws.iam.model.ListGroupPoliciesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, PolicyNameType] =
    ZStream.serviceWithStream(_.listGroupPolicies(request))
  def listGroupPoliciesPaginated(
      request: zio.aws.iam.model.ListGroupPoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupPoliciesPaginated(request))
  def deleteInstanceProfile(
      request: zio.aws.iam.model.DeleteInstanceProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteInstanceProfile(request))
  def createGroup(request: zio.aws.iam.model.CreateGroupRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroup(request))
  def untagMFADevice(
      request: zio.aws.iam.model.UntagMfaDeviceRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagMFADevice(request))
  def createAccountAlias(
      request: zio.aws.iam.model.CreateAccountAliasRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createAccountAlias(request))
  def attachGroupPolicy(
      request: zio.aws.iam.model.AttachGroupPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.attachGroupPolicy(request))
  def setSecurityTokenServicePreferences(
      request: zio.aws.iam.model.SetSecurityTokenServicePreferencesRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setSecurityTokenServicePreferences(request))
  def putUserPolicy(
      request: zio.aws.iam.model.PutUserPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putUserPolicy(request))
  def listAttachedUserPolicies(
      request: zio.aws.iam.model.ListAttachedUserPoliciesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.AttachedPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttachedUserPolicies(request))
  def listAttachedUserPoliciesPaginated(
      request: zio.aws.iam.model.ListAttachedUserPoliciesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListAttachedUserPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachedUserPoliciesPaginated(request))
  def attachUserPolicy(
      request: zio.aws.iam.model.AttachUserPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.attachUserPolicy(request))
  def deleteServiceLinkedRole(
      request: zio.aws.iam.model.DeleteServiceLinkedRoleRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceLinkedRole(request))
  def listUserTags(
      request: zio.aws.iam.model.ListUserTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listUserTags(request))
  def listUserTagsPaginated(
      request: zio.aws.iam.model.ListUserTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListUserTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserTagsPaginated(request))
  def updateRoleDescription(
      request: zio.aws.iam.model.UpdateRoleDescriptionRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoleDescription(request))
  def updateLoginProfile(
      request: zio.aws.iam.model.UpdateLoginProfileRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateLoginProfile(request))
  def attachRolePolicy(
      request: zio.aws.iam.model.AttachRolePolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.attachRolePolicy(request))
  def tagMFADevice(
      request: zio.aws.iam.model.TagMfaDeviceRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagMFADevice(request))
  def updateGroup(
      request: zio.aws.iam.model.UpdateGroupRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateGroup(request))
  def simulatePrincipalPolicy(
      request: zio.aws.iam.model.SimulatePrincipalPolicyRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.EvaluationResult.ReadOnly
  ] = ZStream.serviceWithStream(_.simulatePrincipalPolicy(request))
  def simulatePrincipalPolicyPaginated(
      request: zio.aws.iam.model.SimulatePrincipalPolicyRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.SimulatePrincipalPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.simulatePrincipalPolicyPaginated(request))
  def updateAccountPasswordPolicy(
      request: zio.aws.iam.model.UpdateAccountPasswordPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAccountPasswordPolicy(request))
  def listAccountAliases(
      request: zio.aws.iam.model.ListAccountAliasesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, AccountAliasType] =
    ZStream.serviceWithStream(_.listAccountAliases(request))
  def listAccountAliasesPaginated(
      request: zio.aws.iam.model.ListAccountAliasesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccountAliasesPaginated(request))
  def updateSSHPublicKey(
      request: zio.aws.iam.model.UpdateSshPublicKeyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateSSHPublicKey(request))
  def deactivateMFADevice(
      request: zio.aws.iam.model.DeactivateMfaDeviceRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deactivateMFADevice(request))
  def getRole(request: zio.aws.iam.model.GetRoleRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRole(request))
  def listOpenIDConnectProviderTags(
      request: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listOpenIDConnectProviderTags(request))
  def listOpenIDConnectProviderTagsPaginated(
      request: zio.aws.iam.model.ListOpenIdConnectProviderTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListOpenIdConnectProviderTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOpenIDConnectProviderTagsPaginated(request))
  def getInstanceProfile(
      request: zio.aws.iam.model.GetInstanceProfileRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceProfile(request))
  def createPolicy(request: zio.aws.iam.model.CreatePolicyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreatePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPolicy(request))
  def getAccountAuthorizationDetails(
      request: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.UserDetail.ReadOnly] =
    ZStream.serviceWithStream(_.getAccountAuthorizationDetails(request))
  def getAccountAuthorizationDetailsPaginated(
      request: zio.aws.iam.model.GetAccountAuthorizationDetailsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountAuthorizationDetailsPaginated(request))
  def listPolicyTags(
      request: zio.aws.iam.model.ListPolicyTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listPolicyTags(request))
  def listPolicyTagsPaginated(
      request: zio.aws.iam.model.ListPolicyTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPolicyTagsPaginated(request))
  def listMFADevices(
      request: zio.aws.iam.model.ListMfaDevicesRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.MFADevice.ReadOnly] =
    ZStream.serviceWithStream(_.listMFADevices(request))
  def listMFADevicesPaginated(
      request: zio.aws.iam.model.ListMfaDevicesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMFADevicesPaginated(request))
  def generateCredentialReport(): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateCredentialReport())
  def listOpenIDConnectProviders(
      request: zio.aws.iam.model.ListOpenIdConnectProvidersRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOpenIDConnectProviders(request))
  def tagSAMLProvider(
      request: zio.aws.iam.model.TagSamlProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagSAMLProvider(request))
  def updateServiceSpecificCredential(
      request: zio.aws.iam.model.UpdateServiceSpecificCredentialRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateServiceSpecificCredential(request))
  def deletePolicy(
      request: zio.aws.iam.model.DeletePolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePolicy(request))
  def deleteUser(
      request: zio.aws.iam.model.DeleteUserRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUser(request))
  def listRoleTags(
      request: zio.aws.iam.model.ListRoleTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listRoleTags(request))
  def listRoleTagsPaginated(
      request: zio.aws.iam.model.ListRoleTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListRoleTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoleTagsPaginated(request))
  def getGroup(
      request: zio.aws.iam.model.GetGroupRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.User.ReadOnly] =
    ZStream.serviceWithStream(_.getGroup(request))
  def getGroupPaginated(request: zio.aws.iam.model.GetGroupRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupPaginated(request))
  def getPolicy(request: zio.aws.iam.model.GetPolicyRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicy(request))
  def listInstanceProfiles(
      request: zio.aws.iam.model.ListInstanceProfilesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.InstanceProfile.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceProfiles(request))
  def listInstanceProfilesPaginated(
      request: zio.aws.iam.model.ListInstanceProfilesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceProfilesPaginated(request))
  def getOrganizationsAccessReport(
      request: zio.aws.iam.model.GetOrganizationsAccessReportRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOrganizationsAccessReport(request))
  def listInstanceProfileTags(
      request: zio.aws.iam.model.ListInstanceProfileTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listInstanceProfileTags(request))
  def listInstanceProfileTagsPaginated(
      request: zio.aws.iam.model.ListInstanceProfileTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListInstanceProfileTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceProfileTagsPaginated(request))
  def updateSigningCertificate(
      request: zio.aws.iam.model.UpdateSigningCertificateRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateSigningCertificate(request))
  def listInstanceProfilesForRole(
      request: zio.aws.iam.model.ListInstanceProfilesForRoleRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.InstanceProfile.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstanceProfilesForRole(request))
  def listInstanceProfilesForRolePaginated(
      request: zio.aws.iam.model.ListInstanceProfilesForRoleRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListInstanceProfilesForRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceProfilesForRolePaginated(request))
  def getContextKeysForCustomPolicy(
      request: zio.aws.iam.model.GetContextKeysForCustomPolicyRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContextKeysForCustomPolicy(request))
  def updateAssumeRolePolicy(
      request: zio.aws.iam.model.UpdateAssumeRolePolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAssumeRolePolicy(request))
  def getServerCertificate(
      request: zio.aws.iam.model.GetServerCertificateRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetServerCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServerCertificate(request))
  def createInstanceProfile(
      request: zio.aws.iam.model.CreateInstanceProfileRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstanceProfile(request))
  def listAccessKeys(request: zio.aws.iam.model.ListAccessKeysRequest): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.AccessKeyMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessKeys(request))
  def listAccessKeysPaginated(
      request: zio.aws.iam.model.ListAccessKeysRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListAccessKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessKeysPaginated(request))
  def getServiceLastAccessedDetailsWithEntities(
      request: zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceLastAccessedDetailsWithEntities(request))
  def createPolicyVersion(
      request: zio.aws.iam.model.CreatePolicyVersionRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.CreatePolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPolicyVersion(request))
  def deleteRolePermissionsBoundary(
      request: zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRolePermissionsBoundary(request))
  def deleteSAMLProvider(
      request: zio.aws.iam.model.DeleteSamlProviderRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSAMLProvider(request))
  def listServerCertificates(
      request: zio.aws.iam.model.ListServerCertificatesRequest
  ): ZStream[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listServerCertificates(request))
  def listServerCertificatesPaginated(
      request: zio.aws.iam.model.ListServerCertificatesRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServerCertificatesPaginated(request))
  def getServiceLinkedRoleDeletionStatus(
      request: zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getServiceLinkedRoleDeletionStatus(request))
  def tagPolicy(
      request: zio.aws.iam.model.TagPolicyRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagPolicy(request))
  def getPolicyVersion(request: zio.aws.iam.model.GetPolicyVersionRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicyVersion(request))
  def tagUser(
      request: zio.aws.iam.model.TagUserRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagUser(request))
  def getAccessKeyLastUsed(
      request: zio.aws.iam.model.GetAccessKeyLastUsedRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessKeyLastUsed(request))
  def untagServerCertificate(
      request: zio.aws.iam.model.UntagServerCertificateRequest
  ): ZIO[zio.aws.iam.Iam, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagServerCertificate(request))
  def getSAMLProvider(request: zio.aws.iam.model.GetSamlProviderRequest): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetSamlProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSAMLProvider(request))
  def listServerCertificateTags(
      request: zio.aws.iam.model.ListServerCertificateTagsRequest
  ): ZStream[zio.aws.iam.Iam, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listServerCertificateTags(request))
  def listServerCertificateTagsPaginated(
      request: zio.aws.iam.model.ListServerCertificateTagsRequest
  ): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.ListServerCertificateTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServerCertificateTagsPaginated(request))
  def getCredentialReport(): ZIO[
    zio.aws.iam.Iam,
    AwsError,
    zio.aws.iam.model.GetCredentialReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCredentialReport())
}
