package zio.aws.iam.model
import zio.aws.iam.model.primitives.UserNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLoginProfileRequest(userName: UserNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest = {
    import DeleteLoginProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteLoginProfileRequest.ReadOnly =
    zio.aws.iam.model.DeleteLoginProfileRequest.wrap(buildAwsValue())
}
object DeleteLoginProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteLoginProfileRequest =
      zio.aws.iam.model.DeleteLoginProfileRequest(userName)
    def userName: UserNameType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest
  ) extends zio.aws.iam.model.DeleteLoginProfileRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest
  ): zio.aws.iam.model.DeleteLoginProfileRequest.ReadOnly = new Wrapper(impl)
}
