package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  AuthenticationCodeType,
  SerialNumberType,
  ExistingUserNameType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnableMfaDeviceRequest(
    userName: ExistingUserNameType,
    serialNumber: SerialNumberType,
    authenticationCode1: AuthenticationCodeType,
    authenticationCode2: AuthenticationCodeType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest = {
    import EnableMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .authenticationCode1(
        AuthenticationCodeType.unwrap(authenticationCode1): java.lang.String
      )
      .authenticationCode2(
        AuthenticationCodeType.unwrap(authenticationCode2): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.EnableMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.EnableMfaDeviceRequest.wrap(buildAwsValue())
}
object EnableMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.EnableMfaDeviceRequest =
      zio.aws.iam.model.EnableMfaDeviceRequest(
        userName,
        serialNumber,
        authenticationCode1,
        authenticationCode2
      )
    def userName: ExistingUserNameType
    def serialNumber: SerialNumberType
    def authenticationCode1: AuthenticationCodeType
    def authenticationCode2: AuthenticationCodeType
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getAuthenticationCode1: ZIO[Any, Nothing, AuthenticationCodeType] =
      ZIO.succeed(authenticationCode1)
    def getAuthenticationCode2: ZIO[Any, Nothing, AuthenticationCodeType] =
      ZIO.succeed(authenticationCode2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest
  ) extends zio.aws.iam.model.EnableMfaDeviceRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val authenticationCode1: AuthenticationCodeType =
      zio.aws.iam.model.primitives
        .AuthenticationCodeType(impl.authenticationCode1())
    override val authenticationCode2: AuthenticationCodeType =
      zio.aws.iam.model.primitives
        .AuthenticationCodeType(impl.authenticationCode2())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest
  ): zio.aws.iam.model.EnableMfaDeviceRequest.ReadOnly = new Wrapper(impl)
}
