package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLoginProfileResponse(
    loginProfile: zio.aws.iam.model.LoginProfile
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetLoginProfileResponse = {
    import GetLoginProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetLoginProfileResponse
      .builder()
      .loginProfile(loginProfile.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetLoginProfileResponse.ReadOnly =
    zio.aws.iam.model.GetLoginProfileResponse.wrap(buildAwsValue())
}
object GetLoginProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetLoginProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetLoginProfileResponse =
      zio.aws.iam.model.GetLoginProfileResponse(loginProfile.asEditable)
    def loginProfile: zio.aws.iam.model.LoginProfile.ReadOnly
    def getLoginProfile
        : ZIO[Any, Nothing, zio.aws.iam.model.LoginProfile.ReadOnly] =
      ZIO.succeed(loginProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetLoginProfileResponse
  ) extends zio.aws.iam.model.GetLoginProfileResponse.ReadOnly {
    override val loginProfile: zio.aws.iam.model.LoginProfile.ReadOnly =
      zio.aws.iam.model.LoginProfile.wrap(impl.loginProfile())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetLoginProfileResponse
  ): zio.aws.iam.model.GetLoginProfileResponse.ReadOnly = new Wrapper(impl)
}
