package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  SerialNumberType,
  DateType,
  CertificationValueType,
  UserNameType,
  CertificationKeyType
}
import scala.jdk.CollectionConverters.*
final case class GetMfaDeviceResponse(
    userName: Optional[UserNameType] = Optional.Absent,
    serialNumber: SerialNumberType,
    enableDate: Optional[DateType] = Optional.Absent,
    certifications: Optional[
      Map[CertificationKeyType, CertificationValueType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse = {
    import GetMfaDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .optionallyWith(enableDate.map(value => DateType.unwrap(value): Instant))(
        _.enableDate
      )
      .optionallyWith(
        certifications.map(value =>
          value
            .map({ case (key, value) =>
              (CertificationKeyType
                .unwrap(key): java.lang.String) -> (CertificationValueType
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.certifications)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetMfaDeviceResponse.ReadOnly =
    zio.aws.iam.model.GetMfaDeviceResponse.wrap(buildAwsValue())
}
object GetMfaDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetMfaDeviceResponse =
      zio.aws.iam.model.GetMfaDeviceResponse(
        userName.map(value => value),
        serialNumber,
        enableDate.map(value => value),
        certifications.map(value => value)
      )
    def userName: Optional[UserNameType]
    def serialNumber: SerialNumberType
    def enableDate: Optional[DateType]
    def certifications
        : Optional[Map[CertificationKeyType, CertificationValueType]]
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getEnableDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("enableDate", enableDate)
    def getCertifications: ZIO[Any, AwsError, Map[
      CertificationKeyType,
      CertificationValueType
    ]] = AwsError.unwrapOptionField("certifications", certifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse
  ) extends zio.aws.iam.model.GetMfaDeviceResponse.ReadOnly {
    override val userName: Optional[UserNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val enableDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.enableDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val certifications
        : Optional[Map[CertificationKeyType, CertificationValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certifications())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iam.model.primitives.CertificationKeyType(
                key
              ) -> zio.aws.iam.model.primitives.CertificationValueType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetMfaDeviceResponse
  ): zio.aws.iam.model.GetMfaDeviceResponse.ReadOnly = new Wrapper(impl)
}
