package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType, DateType}
import scala.jdk.CollectionConverters.*
final case class GetServiceLastAccessedDetailsResponse(
    jobStatus: zio.aws.iam.model.JobStatusType,
    jobType: Optional[zio.aws.iam.model.AccessAdvisorUsageGranularityType] =
      Optional.Absent,
    jobCreationDate: DateType,
    servicesLastAccessed: Iterable[zio.aws.iam.model.ServiceLastAccessed],
    jobCompletionDate: DateType,
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent,
    error: Optional[zio.aws.iam.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse = {
    import GetServiceLastAccessedDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse
      .builder()
      .jobStatus(jobStatus.unwrap)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .jobCreationDate(DateType.unwrap(jobCreationDate): Instant)
      .servicesLastAccessed(servicesLastAccessed.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .jobCompletionDate(DateType.unwrap(jobCompletionDate): Instant)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly =
    zio.aws.iam.model.GetServiceLastAccessedDetailsResponse
      .wrap(buildAwsValue())
}
object GetServiceLastAccessedDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetServiceLastAccessedDetailsResponse =
      zio.aws.iam.model.GetServiceLastAccessedDetailsResponse(
        jobStatus,
        jobType.map(value => value),
        jobCreationDate,
        servicesLastAccessed.map { item =>
          item.asEditable
        },
        jobCompletionDate,
        isTruncated.map(value => value),
        marker.map(value => value),
        error.map(value => value.asEditable)
      )
    def jobStatus: zio.aws.iam.model.JobStatusType
    def jobType: Optional[zio.aws.iam.model.AccessAdvisorUsageGranularityType]
    def jobCreationDate: DateType
    def servicesLastAccessed
        : List[zio.aws.iam.model.ServiceLastAccessed.ReadOnly]
    def jobCompletionDate: DateType
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def error: Optional[zio.aws.iam.model.ErrorDetails.ReadOnly]
    def getJobStatus: ZIO[Any, Nothing, zio.aws.iam.model.JobStatusType] =
      ZIO.succeed(jobStatus)
    def getJobType: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AccessAdvisorUsageGranularityType
    ] = AwsError.unwrapOptionField("jobType", jobType)
    def getJobCreationDate: ZIO[Any, Nothing, DateType] =
      ZIO.succeed(jobCreationDate)
    def getServicesLastAccessed: ZIO[Any, Nothing, List[
      zio.aws.iam.model.ServiceLastAccessed.ReadOnly
    ]] = ZIO.succeed(servicesLastAccessed)
    def getJobCompletionDate: ZIO[Any, Nothing, DateType] =
      ZIO.succeed(jobCompletionDate)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getError: ZIO[Any, AwsError, zio.aws.iam.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse
  ) extends zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly {
    override val jobStatus: zio.aws.iam.model.JobStatusType =
      zio.aws.iam.model.JobStatusType.wrap(impl.jobStatus())
    override val jobType
        : Optional[zio.aws.iam.model.AccessAdvisorUsageGranularityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value =>
          zio.aws.iam.model.AccessAdvisorUsageGranularityType.wrap(value)
        )
    override val jobCreationDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.jobCreationDate())
    override val servicesLastAccessed
        : List[zio.aws.iam.model.ServiceLastAccessed.ReadOnly] = impl
      .servicesLastAccessed()
      .asScala
      .map { item =>
        zio.aws.iam.model.ServiceLastAccessed.wrap(item)
      }
      .toList
    override val jobCompletionDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.jobCompletionDate())
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
    override val error: Optional[zio.aws.iam.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iam.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse
  ): zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
