package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, GroupNameType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListGroupPoliciesRequest(
    groupName: GroupNameType,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest = {
    import ListGroupPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListGroupPoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListGroupPoliciesRequest.wrap(buildAwsValue())
}
object ListGroupPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListGroupPoliciesRequest =
      zio.aws.iam.model.ListGroupPoliciesRequest(
        groupName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def groupName: GroupNameType
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest
  ) extends zio.aws.iam.model.ListGroupPoliciesRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest
  ): zio.aws.iam.model.ListGroupPoliciesRequest.ReadOnly = new Wrapper(impl)
}
