package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListUsersResponse(
    users: Iterable[zio.aws.iam.model.User],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListUsersResponse
      .builder()
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListUsersResponse.ReadOnly =
    zio.aws.iam.model.ListUsersResponse.wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListUsersResponse =
      zio.aws.iam.model.ListUsersResponse(
        users.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def users: List[zio.aws.iam.model.User.ReadOnly]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getUsers: ZIO[Any, Nothing, List[zio.aws.iam.model.User.ReadOnly]] =
      ZIO.succeed(users)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListUsersResponse
  ) extends zio.aws.iam.model.ListUsersResponse.ReadOnly {
    override val users: List[zio.aws.iam.model.User.ReadOnly] = impl
      .users()
      .asScala
      .map { item =>
        zio.aws.iam.model.User.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListUsersResponse
  ): zio.aws.iam.model.ListUsersResponse.ReadOnly = new Wrapper(impl)
}
