package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyOwnerEntityType {
  def unwrap: software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType
}
object PolicyOwnerEntityType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType
  ): zio.aws.iam.model.PolicyOwnerEntityType = value match {
    case software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.ROLE =>
      val r = ROLE
      r
    case software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iam.model.PolicyOwnerEntityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType =
      software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.iam.model.PolicyOwnerEntityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType =
      software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.USER
  }
  case object ROLE extends zio.aws.iam.model.PolicyOwnerEntityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType =
      software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.ROLE
  }
  case object GROUP extends zio.aws.iam.model.PolicyOwnerEntityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType =
      software.amazon.awssdk.services.iam.model.PolicyOwnerEntityType.GROUP
  }
}
