package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, ServerCertificateNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagServerCertificateRequest(
    serverCertificateName: ServerCertificateNameType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest = {
    import UntagServerCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest
      .builder()
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagServerCertificateRequest.ReadOnly =
    zio.aws.iam.model.UntagServerCertificateRequest.wrap(buildAwsValue())
}
object UntagServerCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagServerCertificateRequest =
      zio.aws.iam.model
        .UntagServerCertificateRequest(serverCertificateName, tagKeys)
    def serverCertificateName: ServerCertificateNameType
    def tagKeys: List[TagKeyType]
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest
  ) extends zio.aws.iam.model.UntagServerCertificateRequest.ReadOnly {
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagServerCertificateRequest
  ): zio.aws.iam.model.UntagServerCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
