package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  UserNameType,
  PathType,
  ExistingUserNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateUserRequest(
    userName: ExistingUserNameType,
    newPath: Optional[PathType] = Optional.Absent,
    newUserName: Optional[UserNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateUserRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .optionallyWith(
        newPath.map(value => PathType.unwrap(value): java.lang.String)
      )(_.newPath)
      .optionallyWith(
        newUserName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.newUserName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateUserRequest.ReadOnly =
    zio.aws.iam.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateUserRequest =
      zio.aws.iam.model.UpdateUserRequest(
        userName,
        newPath.map(value => value),
        newUserName.map(value => value)
      )
    def userName: ExistingUserNameType
    def newPath: Optional[PathType]
    def newUserName: Optional[UserNameType]
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getNewPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("newPath", newPath)
    def getNewUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("newUserName", newUserName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateUserRequest
  ) extends zio.aws.iam.model.UpdateUserRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val newPath: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.newPath())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val newUserName: Optional[UserNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.newUserName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateUserRequest
  ): zio.aws.iam.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
