package zio.aws.iam
import zio.aws.iam.model.primitives.ServiceUserName.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.iam.model.primitives.{
  PolicyNameType,
  ArnType,
  ThumbprintType,
  CertificationValueType,
  PolicyDocumentType,
  ResourceNameType,
  GroupNameType,
  ContextKeyNameType,
  TagKeyType,
  ServiceNamespaceType,
  CertificationKeyType,
  EvalDecisionSourceType,
  SummaryValueType,
  ClientIDType,
  ActionNameType,
  ContextKeyValueType,
  AccountAliasType
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccessKeyIdType extends zio.prelude.Subtype[String]
    type AccessKeyIdType = zio.aws.iam.model.primitives.AccessKeyIdType.Type
    object AccessKeySecretType extends zio.prelude.Subtype[String]
    type AccessKeySecretType =
      zio.aws.iam.model.primitives.AccessKeySecretType.Type
    object AccountAliasType extends zio.prelude.Subtype[String]
    type AccountAliasType = zio.aws.iam.model.primitives.AccountAliasType.Type
    object ActionNameType extends zio.prelude.Subtype[String]
    type ActionNameType = zio.aws.iam.model.primitives.ActionNameType.Type
    object ArnType extends zio.prelude.Subtype[String]
    type ArnType = zio.aws.iam.model.primitives.ArnType.Type
    object AttachmentCountType extends zio.prelude.Subtype[Int]
    type AttachmentCountType =
      zio.aws.iam.model.primitives.AttachmentCountType.Type
    object AuthenticationCodeType extends zio.prelude.Subtype[String]
    type AuthenticationCodeType =
      zio.aws.iam.model.primitives.AuthenticationCodeType.Type
    object BooleanObjectType extends zio.prelude.Subtype[Boolean]
    type BooleanObjectType = zio.aws.iam.model.primitives.BooleanObjectType.Type
    object BooleanType extends zio.prelude.Subtype[Boolean]
    type BooleanType = zio.aws.iam.model.primitives.BooleanType.Type
    object BootstrapDatum extends zio.prelude.Subtype[Chunk[Byte]]
    type BootstrapDatum = zio.aws.iam.model.primitives.BootstrapDatum.Type
    object CertificateBodyType extends zio.prelude.Subtype[String]
    type CertificateBodyType =
      zio.aws.iam.model.primitives.CertificateBodyType.Type
    object CertificateChainType extends zio.prelude.Subtype[String]
    type CertificateChainType =
      zio.aws.iam.model.primitives.CertificateChainType.Type
    object CertificateIdType extends zio.prelude.Subtype[String]
    type CertificateIdType = zio.aws.iam.model.primitives.CertificateIdType.Type
    object CertificationKeyType extends zio.prelude.Subtype[String]
    type CertificationKeyType =
      zio.aws.iam.model.primitives.CertificationKeyType.Type
    object CertificationValueType extends zio.prelude.Subtype[String]
    type CertificationValueType =
      zio.aws.iam.model.primitives.CertificationValueType.Type
    object ClientIDType extends zio.prelude.Subtype[String]
    type ClientIDType = zio.aws.iam.model.primitives.ClientIDType.Type
    object ColumnNumber extends zio.prelude.Subtype[Int]
    type ColumnNumber = zio.aws.iam.model.primitives.ColumnNumber.Type
    object ContextKeyNameType extends zio.prelude.Subtype[String]
    type ContextKeyNameType =
      zio.aws.iam.model.primitives.ContextKeyNameType.Type
    object ContextKeyValueType extends zio.prelude.Subtype[String]
    type ContextKeyValueType =
      zio.aws.iam.model.primitives.ContextKeyValueType.Type
    object CustomSuffixType extends zio.prelude.Subtype[String]
    type CustomSuffixType = zio.aws.iam.model.primitives.CustomSuffixType.Type
    object DateType extends zio.prelude.Subtype[Instant]
    type DateType = zio.aws.iam.model.primitives.DateType.Type
    object DeletionTaskIdType extends zio.prelude.Subtype[String]
    type DeletionTaskIdType =
      zio.aws.iam.model.primitives.DeletionTaskIdType.Type
    object EntityNameType extends zio.prelude.Subtype[String]
    type EntityNameType = zio.aws.iam.model.primitives.EntityNameType.Type
    object EvalDecisionSourceType extends zio.prelude.Subtype[String]
    type EvalDecisionSourceType =
      zio.aws.iam.model.primitives.EvalDecisionSourceType.Type
    object ExistingUserNameType extends zio.prelude.Subtype[String]
    type ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType.Type
    object GroupNameType extends zio.prelude.Subtype[String]
    type GroupNameType = zio.aws.iam.model.primitives.GroupNameType.Type
    object IdType extends zio.prelude.Subtype[String]
    type IdType = zio.aws.iam.model.primitives.IdType.Type
    object InstanceProfileNameType extends zio.prelude.Subtype[String]
    type InstanceProfileNameType =
      zio.aws.iam.model.primitives.InstanceProfileNameType.Type
    object IntegerType extends zio.prelude.Subtype[Int]
    type IntegerType = zio.aws.iam.model.primitives.IntegerType.Type
    object JobIDType extends zio.prelude.Subtype[String]
    type JobIDType = zio.aws.iam.model.primitives.JobIDType.Type
    object LineNumber extends zio.prelude.Subtype[Int]
    type LineNumber = zio.aws.iam.model.primitives.LineNumber.Type
    object MarkerType extends zio.prelude.Subtype[String]
    type MarkerType = zio.aws.iam.model.primitives.MarkerType.Type
    object MaxItemsType extends zio.prelude.Subtype[Int]
    type MaxItemsType = zio.aws.iam.model.primitives.MaxItemsType.Type
    object MaxPasswordAgeType extends zio.prelude.Subtype[Int]
    type MaxPasswordAgeType =
      zio.aws.iam.model.primitives.MaxPasswordAgeType.Type
    object MinimumPasswordLengthType extends zio.prelude.Subtype[Int]
    type MinimumPasswordLengthType =
      zio.aws.iam.model.primitives.MinimumPasswordLengthType.Type
    object OpenIDConnectProviderUrlType extends zio.prelude.Subtype[String]
    type OpenIDConnectProviderUrlType =
      zio.aws.iam.model.primitives.OpenIDConnectProviderUrlType.Type
    object OrganizationsEntityPathType extends zio.prelude.Subtype[String]
    type OrganizationsEntityPathType =
      zio.aws.iam.model.primitives.OrganizationsEntityPathType.Type
    object OrganizationsPolicyIdType extends zio.prelude.Subtype[String]
    type OrganizationsPolicyIdType =
      zio.aws.iam.model.primitives.OrganizationsPolicyIdType.Type
    object PasswordReusePreventionType extends zio.prelude.Subtype[Int]
    type PasswordReusePreventionType =
      zio.aws.iam.model.primitives.PasswordReusePreventionType.Type
    object PasswordType extends zio.prelude.Subtype[String]
    type PasswordType = zio.aws.iam.model.primitives.PasswordType.Type
    object PathPrefixType extends zio.prelude.Subtype[String]
    type PathPrefixType = zio.aws.iam.model.primitives.PathPrefixType.Type
    object PathType extends zio.prelude.Subtype[String]
    type PathType = zio.aws.iam.model.primitives.PathType.Type
    object PolicyDescriptionType extends zio.prelude.Subtype[String]
    type PolicyDescriptionType =
      zio.aws.iam.model.primitives.PolicyDescriptionType.Type
    object PolicyDocumentType extends zio.prelude.Subtype[String]
    type PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType.Type
    object PolicyIdentifierType extends zio.prelude.Subtype[String]
    type PolicyIdentifierType =
      zio.aws.iam.model.primitives.PolicyIdentifierType.Type
    object PolicyNameType extends zio.prelude.Subtype[String]
    type PolicyNameType = zio.aws.iam.model.primitives.PolicyNameType.Type
    object PolicyPathType extends zio.prelude.Subtype[String]
    type PolicyPathType = zio.aws.iam.model.primitives.PolicyPathType.Type
    object PolicyVersionIdType extends zio.prelude.Subtype[String]
    type PolicyVersionIdType =
      zio.aws.iam.model.primitives.PolicyVersionIdType.Type
    object PrivateKeyType extends zio.prelude.Subtype[String]
    type PrivateKeyType = zio.aws.iam.model.primitives.PrivateKeyType.Type
    object PublicKeyFingerprintType extends zio.prelude.Subtype[String]
    type PublicKeyFingerprintType =
      zio.aws.iam.model.primitives.PublicKeyFingerprintType.Type
    object PublicKeyIdType extends zio.prelude.Subtype[String]
    type PublicKeyIdType = zio.aws.iam.model.primitives.PublicKeyIdType.Type
    object PublicKeyMaterialType extends zio.prelude.Subtype[String]
    type PublicKeyMaterialType =
      zio.aws.iam.model.primitives.PublicKeyMaterialType.Type
    object ReasonType extends zio.prelude.Subtype[String]
    type ReasonType = zio.aws.iam.model.primitives.ReasonType.Type
    object RegionNameType extends zio.prelude.Subtype[String]
    type RegionNameType = zio.aws.iam.model.primitives.RegionNameType.Type
    object ReportContentType extends zio.prelude.Subtype[Chunk[Byte]]
    type ReportContentType = zio.aws.iam.model.primitives.ReportContentType.Type
    object ReportStateDescriptionType extends zio.prelude.Subtype[String]
    type ReportStateDescriptionType =
      zio.aws.iam.model.primitives.ReportStateDescriptionType.Type
    object ResourceHandlingOptionType extends zio.prelude.Subtype[String]
    type ResourceHandlingOptionType =
      zio.aws.iam.model.primitives.ResourceHandlingOptionType.Type
    object ResourceNameType extends zio.prelude.Subtype[String]
    type ResourceNameType = zio.aws.iam.model.primitives.ResourceNameType.Type
    object ResponseMarkerType extends zio.prelude.Subtype[String]
    type ResponseMarkerType =
      zio.aws.iam.model.primitives.ResponseMarkerType.Type
    object RoleDescriptionType extends zio.prelude.Subtype[String]
    type RoleDescriptionType =
      zio.aws.iam.model.primitives.RoleDescriptionType.Type
    object RoleMaxSessionDurationType extends zio.prelude.Subtype[Int]
    type RoleMaxSessionDurationType =
      zio.aws.iam.model.primitives.RoleMaxSessionDurationType.Type
    object RoleNameType extends zio.prelude.Subtype[String]
    type RoleNameType = zio.aws.iam.model.primitives.RoleNameType.Type
    object SAMLMetadataDocumentType extends zio.prelude.Subtype[String]
    type SAMLMetadataDocumentType =
      zio.aws.iam.model.primitives.SAMLMetadataDocumentType.Type
    object SAMLProviderNameType extends zio.prelude.Subtype[String]
    type SAMLProviderNameType =
      zio.aws.iam.model.primitives.SAMLProviderNameType.Type
    object SerialNumberType extends zio.prelude.Subtype[String]
    type SerialNumberType = zio.aws.iam.model.primitives.SerialNumberType.Type
    object ServerCertificateNameType extends zio.prelude.Subtype[String]
    type ServerCertificateNameType =
      zio.aws.iam.model.primitives.ServerCertificateNameType.Type
    object ServiceName extends zio.prelude.Subtype[String]
    type ServiceName = zio.aws.iam.model.primitives.ServiceName.Type
    object ServiceNameType extends zio.prelude.Subtype[String]
    type ServiceNameType = zio.aws.iam.model.primitives.ServiceNameType.Type
    object ServiceNamespaceType extends zio.prelude.Subtype[String]
    type ServiceNamespaceType =
      zio.aws.iam.model.primitives.ServiceNamespaceType.Type
    object ServicePassword extends zio.prelude.Subtype[String]
    type ServicePassword = zio.aws.iam.model.primitives.ServicePassword.Type
    object ServiceSpecificCredentialId extends zio.prelude.Subtype[String]
    type ServiceSpecificCredentialId =
      zio.aws.iam.model.primitives.ServiceSpecificCredentialId.Type
    object ServiceUserName extends zio.prelude.Subtype[String]
    type ServiceUserName = zio.aws.iam.model.primitives.ServiceUserName.Type
    type StringType = String
    object SummaryValueType extends zio.prelude.Subtype[Int]
    type SummaryValueType = zio.aws.iam.model.primitives.SummaryValueType.Type
    object TagKeyType extends zio.prelude.Subtype[String]
    type TagKeyType = zio.aws.iam.model.primitives.TagKeyType.Type
    object TagValueType extends zio.prelude.Subtype[String]
    type TagValueType = zio.aws.iam.model.primitives.TagValueType.Type
    object ThumbprintType extends zio.prelude.Subtype[String]
    type ThumbprintType = zio.aws.iam.model.primitives.ThumbprintType.Type
    object UserNameType extends zio.prelude.Subtype[String]
    type UserNameType = zio.aws.iam.model.primitives.UserNameType.Type
    object VirtualMFADeviceName extends zio.prelude.Subtype[String]
    type VirtualMFADeviceName =
      zio.aws.iam.model.primitives.VirtualMFADeviceName.Type
  }
  type AccessDetails = List[zio.aws.iam.model.AccessDetail]
  type AccessKeyMetadataListType = List[zio.aws.iam.model.AccessKeyMetadata]
  type AccountAliasListType = List[AccountAliasType]
  type ActionNameListType = List[ActionNameType]
  type ArnListType = List[ArnType]
  type AttachedPoliciesListType = List[zio.aws.iam.model.AttachedPolicy]
  type CertificateListType = List[zio.aws.iam.model.SigningCertificate]
  type CertificationMapType = Map[CertificationKeyType, CertificationValueType]
  type ClientIDListType = List[ClientIDType]
  type ContextEntryListType = List[zio.aws.iam.model.ContextEntry]
  type ContextKeyNamesResultListType = List[ContextKeyNameType]
  type ContextKeyValueListType = List[ContextKeyValueType]
  type EntityDetailsListType = List[zio.aws.iam.model.EntityDetails]
  type EntityListType = List[zio.aws.iam.model.EntityType]
  type EvalDecisionDetailsType =
    Map[EvalDecisionSourceType, zio.aws.iam.model.PolicyEvaluationDecisionType]
  type EvaluationResultsListType = List[zio.aws.iam.model.EvaluationResult]
  type GroupDetailListType = List[zio.aws.iam.model.GroupDetail]
  type GroupListType = List[zio.aws.iam.model.Group]
  type GroupNameListType = List[GroupNameType]
  type InstanceProfileListType = List[zio.aws.iam.model.InstanceProfile]
  type ListPolicyGrantingServiceAccessResponseListType =
    List[zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry]
  type ManagedPolicyDetailListType = List[zio.aws.iam.model.ManagedPolicyDetail]
  type MfaDeviceListType = List[zio.aws.iam.model.MFADevice]
  type OpenIDConnectProviderListType =
    List[zio.aws.iam.model.OpenIDConnectProviderListEntry]
  type PolicyDetailListType = List[zio.aws.iam.model.PolicyDetail]
  type PolicyDocumentVersionListType = List[zio.aws.iam.model.PolicyVersion]
  type PolicyGrantingServiceAccessListType =
    List[zio.aws.iam.model.PolicyGrantingServiceAccess]
  type PolicyGroupListType = List[zio.aws.iam.model.PolicyGroup]
  type PolicyListType = List[zio.aws.iam.model.Policy]
  type PolicyNameListType = List[PolicyNameType]
  type PolicyRoleListType = List[zio.aws.iam.model.PolicyRole]
  type PolicyUserListType = List[zio.aws.iam.model.PolicyUser]
  type ResourceNameListType = List[ResourceNameType]
  type ResourceSpecificResultListType =
    List[zio.aws.iam.model.ResourceSpecificResult]
  type RoleDetailListType = List[zio.aws.iam.model.RoleDetail]
  type RoleListType = List[zio.aws.iam.model.Role]
  type RoleUsageListType = List[zio.aws.iam.model.RoleUsageType]
  type SAMLProviderListType = List[zio.aws.iam.model.SAMLProviderListEntry]
  type SSHPublicKeyListType = List[zio.aws.iam.model.SSHPublicKeyMetadata]
  type ServerCertificateMetadataListType =
    List[zio.aws.iam.model.ServerCertificateMetadata]
  type ServiceNamespaceListType = List[ServiceNamespaceType]
  type ServiceSpecificCredentialsListType =
    List[zio.aws.iam.model.ServiceSpecificCredentialMetadata]
  type ServicesLastAccessed = List[zio.aws.iam.model.ServiceLastAccessed]
  type SimulationPolicyListType = List[PolicyDocumentType]
  type StatementListType = List[zio.aws.iam.model.Statement]
  type SummaryMapType = Map[zio.aws.iam.model.SummaryKeyType, SummaryValueType]
  type TagKeyListType = List[TagKeyType]
  type TagListType = List[zio.aws.iam.model.Tag]
  type ThumbprintListType = List[ThumbprintType]
  type TrackedActionsLastAccessed =
    List[zio.aws.iam.model.TrackedActionLastAccessed]
  type UserDetailListType = List[zio.aws.iam.model.UserDetail]
  type UserListType = List[zio.aws.iam.model.User]
  type VirtualMFADeviceListType = List[zio.aws.iam.model.VirtualMFADevice]
}
