package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait AggregationFindingType {
  def unwrap
      : software.amazon.awssdk.services.inspector2.model.AggregationFindingType
}
object AggregationFindingType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.AggregationFindingType
  ): zio.aws.inspector2.model.AggregationFindingType = value match {
    case software.amazon.awssdk.services.inspector2.model.AggregationFindingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationFindingType.NETWORK_REACHABILITY =>
      val r = NETWORK_REACHABILITY
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationFindingType.PACKAGE_VULNERABILITY =>
      val r = PACKAGE_VULNERABILITY
      r
    case software.amazon.awssdk.services.inspector2.model.AggregationFindingType.CODE_VULNERABILITY =>
      val r = CODE_VULNERABILITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.AggregationFindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationFindingType =
      software.amazon.awssdk.services.inspector2.model.AggregationFindingType.UNKNOWN_TO_SDK_VERSION
  }
  case object NETWORK_REACHABILITY
      extends zio.aws.inspector2.model.AggregationFindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationFindingType =
      software.amazon.awssdk.services.inspector2.model.AggregationFindingType.NETWORK_REACHABILITY
  }
  case object PACKAGE_VULNERABILITY
      extends zio.aws.inspector2.model.AggregationFindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationFindingType =
      software.amazon.awssdk.services.inspector2.model.AggregationFindingType.PACKAGE_VULNERABILITY
  }
  case object CODE_VULNERABILITY
      extends zio.aws.inspector2.model.AggregationFindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.AggregationFindingType =
      software.amazon.awssdk.services.inspector2.model.AggregationFindingType.CODE_VULNERABILITY
  }
}
