package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregationResponse(
    accountAggregation: Optional[
      zio.aws.inspector2.model.AccountAggregationResponse
    ] = Optional.Absent,
    amiAggregation: Optional[zio.aws.inspector2.model.AmiAggregationResponse] =
      Optional.Absent,
    awsEcrContainerAggregation: Optional[
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse
    ] = Optional.Absent,
    ec2InstanceAggregation: Optional[
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse
    ] = Optional.Absent,
    findingTypeAggregation: Optional[
      zio.aws.inspector2.model.FindingTypeAggregationResponse
    ] = Optional.Absent,
    imageLayerAggregation: Optional[
      zio.aws.inspector2.model.ImageLayerAggregationResponse
    ] = Optional.Absent,
    lambdaFunctionAggregation: Optional[
      zio.aws.inspector2.model.LambdaFunctionAggregationResponse
    ] = Optional.Absent,
    lambdaLayerAggregation: Optional[
      zio.aws.inspector2.model.LambdaLayerAggregationResponse
    ] = Optional.Absent,
    packageAggregation: Optional[
      zio.aws.inspector2.model.PackageAggregationResponse
    ] = Optional.Absent,
    repositoryAggregation: Optional[
      zio.aws.inspector2.model.RepositoryAggregationResponse
    ] = Optional.Absent,
    titleAggregation: Optional[
      zio.aws.inspector2.model.TitleAggregationResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AggregationResponse = {
    import AggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AggregationResponse
      .builder()
      .optionallyWith(accountAggregation.map(value => value.buildAwsValue()))(
        _.accountAggregation
      )
      .optionallyWith(amiAggregation.map(value => value.buildAwsValue()))(
        _.amiAggregation
      )
      .optionallyWith(
        awsEcrContainerAggregation.map(value => value.buildAwsValue())
      )(_.awsEcrContainerAggregation)
      .optionallyWith(
        ec2InstanceAggregation.map(value => value.buildAwsValue())
      )(_.ec2InstanceAggregation)
      .optionallyWith(
        findingTypeAggregation.map(value => value.buildAwsValue())
      )(_.findingTypeAggregation)
      .optionallyWith(
        imageLayerAggregation.map(value => value.buildAwsValue())
      )(_.imageLayerAggregation)
      .optionallyWith(
        lambdaFunctionAggregation.map(value => value.buildAwsValue())
      )(_.lambdaFunctionAggregation)
      .optionallyWith(
        lambdaLayerAggregation.map(value => value.buildAwsValue())
      )(_.lambdaLayerAggregation)
      .optionallyWith(packageAggregation.map(value => value.buildAwsValue()))(
        _.packageAggregation
      )
      .optionallyWith(
        repositoryAggregation.map(value => value.buildAwsValue())
      )(_.repositoryAggregation)
      .optionallyWith(titleAggregation.map(value => value.buildAwsValue()))(
        _.titleAggregation
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AggregationResponse.ReadOnly =
    zio.aws.inspector2.model.AggregationResponse.wrap(buildAwsValue())
}
object AggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AggregationResponse =
      zio.aws.inspector2.model.AggregationResponse(
        accountAggregation.map(value => value.asEditable),
        amiAggregation.map(value => value.asEditable),
        awsEcrContainerAggregation.map(value => value.asEditable),
        ec2InstanceAggregation.map(value => value.asEditable),
        findingTypeAggregation.map(value => value.asEditable),
        imageLayerAggregation.map(value => value.asEditable),
        lambdaFunctionAggregation.map(value => value.asEditable),
        lambdaLayerAggregation.map(value => value.asEditable),
        packageAggregation.map(value => value.asEditable),
        repositoryAggregation.map(value => value.asEditable),
        titleAggregation.map(value => value.asEditable)
      )
    def accountAggregation
        : Optional[zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly]
    def amiAggregation
        : Optional[zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly]
    def awsEcrContainerAggregation: Optional[
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly
    ]
    def ec2InstanceAggregation: Optional[
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly
    ]
    def findingTypeAggregation: Optional[
      zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly
    ]
    def imageLayerAggregation: Optional[
      zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly
    ]
    def lambdaFunctionAggregation: Optional[
      zio.aws.inspector2.model.LambdaFunctionAggregationResponse.ReadOnly
    ]
    def lambdaLayerAggregation: Optional[
      zio.aws.inspector2.model.LambdaLayerAggregationResponse.ReadOnly
    ]
    def packageAggregation
        : Optional[zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly]
    def repositoryAggregation: Optional[
      zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly
    ]
    def titleAggregation
        : Optional[zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly]
    def getAccountAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("accountAggregation", accountAggregation)
    def getAmiAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("amiAggregation", amiAggregation)
    def getAwsEcrContainerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEcrContainerAggregation",
      awsEcrContainerAggregation
    )
    def getEc2InstanceAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2InstanceAggregation",
      ec2InstanceAggregation
    )
    def getFindingTypeAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "findingTypeAggregation",
      findingTypeAggregation
    )
    def getImageLayerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("imageLayerAggregation", imageLayerAggregation)
    def getLambdaFunctionAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.LambdaFunctionAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionAggregation",
      lambdaFunctionAggregation
    )
    def getLambdaLayerAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.LambdaLayerAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaLayerAggregation",
      lambdaLayerAggregation
    )
    def getPackageAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("packageAggregation", packageAggregation)
    def getRepositoryAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("repositoryAggregation", repositoryAggregation)
    def getTitleAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("titleAggregation", titleAggregation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationResponse
  ) extends zio.aws.inspector2.model.AggregationResponse.ReadOnly {
    override val accountAggregation: Optional[
      zio.aws.inspector2.model.AccountAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAggregation())
      .map(value =>
        zio.aws.inspector2.model.AccountAggregationResponse.wrap(value)
      )
    override val amiAggregation
        : Optional[zio.aws.inspector2.model.AmiAggregationResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amiAggregation())
        .map(value =>
          zio.aws.inspector2.model.AmiAggregationResponse.wrap(value)
        )
    override val awsEcrContainerAggregation: Optional[
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsEcrContainerAggregation())
      .map(value =>
        zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.wrap(value)
      )
    override val ec2InstanceAggregation: Optional[
      zio.aws.inspector2.model.Ec2InstanceAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceAggregation())
      .map(value =>
        zio.aws.inspector2.model.Ec2InstanceAggregationResponse.wrap(value)
      )
    override val findingTypeAggregation: Optional[
      zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.findingTypeAggregation())
      .map(value =>
        zio.aws.inspector2.model.FindingTypeAggregationResponse.wrap(value)
      )
    override val imageLayerAggregation: Optional[
      zio.aws.inspector2.model.ImageLayerAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageLayerAggregation())
      .map(value =>
        zio.aws.inspector2.model.ImageLayerAggregationResponse.wrap(value)
      )
    override val lambdaFunctionAggregation: Optional[
      zio.aws.inspector2.model.LambdaFunctionAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionAggregation())
      .map(value =>
        zio.aws.inspector2.model.LambdaFunctionAggregationResponse.wrap(value)
      )
    override val lambdaLayerAggregation: Optional[
      zio.aws.inspector2.model.LambdaLayerAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaLayerAggregation())
      .map(value =>
        zio.aws.inspector2.model.LambdaLayerAggregationResponse.wrap(value)
      )
    override val packageAggregation: Optional[
      zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.packageAggregation())
      .map(value =>
        zio.aws.inspector2.model.PackageAggregationResponse.wrap(value)
      )
    override val repositoryAggregation: Optional[
      zio.aws.inspector2.model.RepositoryAggregationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryAggregation())
      .map(value =>
        zio.aws.inspector2.model.RepositoryAggregationResponse.wrap(value)
      )
    override val titleAggregation
        : Optional[zio.aws.inspector2.model.TitleAggregationResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.titleAggregation())
        .map(value =>
          zio.aws.inspector2.model.TitleAggregationResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AggregationResponse
  ): zio.aws.inspector2.model.AggregationResponse.ReadOnly = new Wrapper(impl)
}
