package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{Ttp, Target, LastSeen, FirstSeen}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AtigData(
    firstSeen: Optional[FirstSeen] = Optional.Absent,
    lastSeen: Optional[LastSeen] = Optional.Absent,
    targets: Optional[Iterable[Target]] = Optional.Absent,
    ttps: Optional[Iterable[Ttp]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AtigData = {
    import AtigData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AtigData
      .builder()
      .optionallyWith(firstSeen.map(value => FirstSeen.unwrap(value): Instant))(
        _.firstSeen
      )
      .optionallyWith(lastSeen.map(value => LastSeen.unwrap(value): Instant))(
        _.lastSeen
      )
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            Target.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        ttps.map(value =>
          value.map { item =>
            Ttp.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ttps)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AtigData.ReadOnly =
    zio.aws.inspector2.model.AtigData.wrap(buildAwsValue())
}
object AtigData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AtigData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AtigData =
      zio.aws.inspector2.model.AtigData(
        firstSeen.map(value => value),
        lastSeen.map(value => value),
        targets.map(value => value),
        ttps.map(value => value)
      )
    def firstSeen: Optional[FirstSeen]
    def lastSeen: Optional[LastSeen]
    def targets: Optional[List[Target]]
    def ttps: Optional[List[Ttp]]
    def getFirstSeen: ZIO[Any, AwsError, FirstSeen] =
      AwsError.unwrapOptionField("firstSeen", firstSeen)
    def getLastSeen: ZIO[Any, AwsError, LastSeen] =
      AwsError.unwrapOptionField("lastSeen", lastSeen)
    def getTargets: ZIO[Any, AwsError, List[Target]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTtps: ZIO[Any, AwsError, List[Ttp]] =
      AwsError.unwrapOptionField("ttps", ttps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AtigData
  ) extends zio.aws.inspector2.model.AtigData.ReadOnly {
    override val firstSeen: Optional[FirstSeen] = zio.aws.core.internal
      .optionalFromNullable(impl.firstSeen())
      .map(value => zio.aws.inspector2.model.primitives.FirstSeen(value))
    override val lastSeen: Optional[LastSeen] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeen())
      .map(value => zio.aws.inspector2.model.primitives.LastSeen(value))
    override val targets: Optional[List[Target]] = zio.aws.core.internal
      .optionalFromNullable(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Target(item)
        }.toList
      )
    override val ttps: Optional[List[Ttp]] = zio.aws.core.internal
      .optionalFromNullable(impl.ttps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.Ttp(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AtigData
  ): zio.aws.inspector2.model.AtigData.ReadOnly = new Wrapper(impl)
}
