package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.FindingArn
import scala.jdk.CollectionConverters.*
final case class BatchGetFindingDetailsRequest(
    findingArns: Iterable[FindingArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest = {
    import BatchGetFindingDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest
      .builder()
      .findingArns(findingArns.map { item =>
        FindingArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetFindingDetailsRequest.ReadOnly =
    zio.aws.inspector2.model.BatchGetFindingDetailsRequest.wrap(buildAwsValue())
}
object BatchGetFindingDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetFindingDetailsRequest =
      zio.aws.inspector2.model.BatchGetFindingDetailsRequest(findingArns)
    def findingArns: List[FindingArn]
    def getFindingArns: ZIO[Any, Nothing, List[FindingArn]] =
      ZIO.succeed(findingArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest
  ) extends zio.aws.inspector2.model.BatchGetFindingDetailsRequest.ReadOnly {
    override val findingArns: List[FindingArn] = impl
      .findingArns()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.FindingArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest
  ): zio.aws.inspector2.model.BatchGetFindingDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
