package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.MeteringAccountId
import scala.jdk.CollectionConverters.*
final case class BatchGetFreeTrialInfoRequest(
    accountIds: Iterable[MeteringAccountId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest = {
    import BatchGetFreeTrialInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest
      .builder()
      .accountIds(accountIds.map { item =>
        MeteringAccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest.ReadOnly =
    zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest.wrap(buildAwsValue())
}
object BatchGetFreeTrialInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest =
      zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest(accountIds)
    def accountIds: List[MeteringAccountId]
    def getAccountIds: ZIO[Any, Nothing, List[MeteringAccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest
  ) extends zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest.ReadOnly {
    override val accountIds: List[MeteringAccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.primitives.MeteringAccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest
  ): zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest.ReadOnly =
    new Wrapper(impl)
}
