package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class BatchGetMemberEc2DeepInspectionStatusRequest(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest = {
    import BatchGetMemberEc2DeepInspectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest.ReadOnly =
    zio.aws.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest
      .wrap(buildAwsValue())
}
object BatchGetMemberEc2DeepInspectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest =
      zio.aws.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest(
        accountIds.map(value => value)
      )
    def accountIds: Optional[List[AccountId]]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest
  ) extends zio.aws.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest
  ): zio.aws.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
