package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchUpdateMemberEc2DeepInspectionStatusRequest(
    accountIds: Iterable[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest = {
    import BatchUpdateMemberEc2DeepInspectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest
      .builder()
      .accountIds(accountIds.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest.ReadOnly =
    zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest
      .wrap(buildAwsValue())
}
object BatchUpdateMemberEc2DeepInspectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest =
      zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest(
        accountIds.map { item =>
          item.asEditable
        }
      )
    def accountIds: List[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.ReadOnly
    ]
    def getAccountIds: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.ReadOnly
    ]] = ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest
  ) extends zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest.ReadOnly {
    override val accountIds: List[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.ReadOnly
    ] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatus.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest
  ): zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
