package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateMemberEc2DeepInspectionStatusResponse(
    accountIds: Optional[Iterable[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState
    ]] = Optional.Absent,
    failedAccountIds: Optional[Iterable[
      zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse = {
    import BatchUpdateMemberEc2DeepInspectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        failedAccountIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedAccountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse.ReadOnly =
    zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse
      .wrap(buildAwsValue())
}
object BatchUpdateMemberEc2DeepInspectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse =
      zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse(
        accountIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedAccountIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountIds: Optional[List[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState.ReadOnly
    ]]
    def failedAccountIds: Optional[List[
      zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.ReadOnly
    ]]
    def getAccountIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState.ReadOnly
    ]] = AwsError.unwrapOptionField("accountIds", accountIds)
    def getFailedAccountIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.ReadOnly
    ]] = AwsError.unwrapOptionField("failedAccountIds", failedAccountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse
  ) extends zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse.ReadOnly {
    override val accountIds: Optional[List[
      zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.MemberAccountEc2DeepInspectionStatusState
            .wrap(item)
        }.toList
      )
    override val failedAccountIds: Optional[List[
      zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.failedAccountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse
  ): zio.aws.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
