package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters.*
final case class CancelSbomExportResponse(
    reportId: Optional[ReportId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse = {
    import CancelSbomExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CancelSbomExportResponse.ReadOnly =
    zio.aws.inspector2.model.CancelSbomExportResponse.wrap(buildAwsValue())
}
object CancelSbomExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CancelSbomExportResponse =
      zio.aws.inspector2.model
        .CancelSbomExportResponse(reportId.map(value => value))
    def reportId: Optional[ReportId]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse
  ) extends zio.aws.inspector2.model.CancelSbomExportResponse.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value => zio.aws.inspector2.model.primitives.ReportId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse
  ): zio.aws.inspector2.model.CancelSbomExportResponse.ReadOnly = new Wrapper(
    impl
  )
}
